// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package internal // import "go.opentelemetry.io/collector/internal/cmd/pdatagen/internal"

var pcommon = &Package{
	info: &PackageInfo{
		name: "pcommon",
		path: "pcommon",
		imports: []string{
			`"go.opentelemetry.io/collector/pdata/internal"`,
			`"go.opentelemetry.io/collector/pdata/internal/json"`,
			`otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"`,
			`otlpresource "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"`,
		},
		testImports: []string{
			`"testing"`,
			``,
			`"github.com/stretchr/testify/assert"`,
			``,
			`"go.opentelemetry.io/collector/pdata/internal"`,
			`"go.opentelemetry.io/collector/pdata/internal/json"`,
		},
	},
	structs: []baseStruct{
		scope,
		resource,
		byteSlice,
		float64Slice,
		uInt64Slice,
		int64Slice,
		int32Slice,
		stringSlice,
	},
}

var scope = &messageStruct{
	structName:     "InstrumentationScope",
	packageName:    "pcommon",
	description:    "// InstrumentationScope is a message representing the instrumentation scope information.",
	originFullName: "otlpcommon.InstrumentationScope",
	fields: []Field{
		nameField,
		&PrimitiveField{
			fieldName:  "Version",
			returnType: "string",
			defaultVal: `""`,
			testVal:    `"test_version"`,
		},
		attributes,
		droppedAttributesCount,
	},
}

// This will not be generated by this class.
// Defined here just to be available as returned message for the fields.
var mapStruct = &sliceOfPtrs{
	structName:  "Map",
	packageName: "pcommon",
}

var scopeField = &MessageField{
	fieldName:     "Scope",
	returnMessage: scope,
}

var traceState = &messageStruct{
	structName:  "TraceState",
	packageName: "pcommon",
}

var timestampType = &TypedType{
	structName:  "Timestamp",
	packageName: "pcommon",
	rawType:     "uint64",
	defaultVal:  "0",
	testVal:     "1234567890",
}

var startTimeField = &TypedField{
	fieldName:       "StartTimestamp",
	originFieldName: "StartTimeUnixNano",
	returnType:      timestampType,
}

var timeField = &TypedField{
	fieldName:       "Timestamp",
	originFieldName: "TimeUnixNano",
	returnType:      timestampType,
}

var endTimeField = &TypedField{
	fieldName:       "EndTimestamp",
	originFieldName: "EndTimeUnixNano",
	returnType:      timestampType,
}

var attributes = &SliceField{
	fieldName:   "Attributes",
	returnSlice: mapStruct,
}

var nameField = &PrimitiveField{
	fieldName:  "Name",
	returnType: "string",
	defaultVal: `""`,
	testVal:    `"test_name"`,
}

var anyValue = &messageStruct{
	structName:     "Value",
	packageName:    "pcommon",
	originFullName: "otlpcommon.AnyValue",
}

var traceIDField = &TypedField{
	fieldName:       "TraceID",
	originFieldName: "TraceId",
	returnType: &TypedType{
		structName:  "TraceID",
		packageName: "pcommon",
		rawType:     "data.TraceID",
		isType:      true,
		defaultVal:  "data.TraceID([16]byte{})",
		testVal:     "data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})",
	},
}

var spanIDField = &TypedField{
	fieldName:       "SpanID",
	originFieldName: "SpanId",
	returnType:      spanIDType,
}

var parentSpanIDField = &TypedField{
	fieldName:       "ParentSpanID",
	originFieldName: "ParentSpanId",
	returnType:      spanIDType,
}

var spanIDType = &TypedType{
	structName:  "SpanID",
	packageName: "pcommon",
	rawType:     "data.SpanID",
	isType:      true,
	defaultVal:  "data.SpanID([8]byte{})",
	testVal:     "data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})",
}

var schemaURLField = &PrimitiveField{
	fieldName:  "SchemaUrl",
	returnType: "string",
	defaultVal: `""`,
	testVal:    `"https://opentelemetry.io/schemas/1.5.0"`,
}

var resource = &messageStruct{
	structName:     "Resource",
	packageName:    "pcommon",
	description:    "// Resource is a message representing the resource information.",
	originFullName: "otlpresource.Resource",
	fields: []Field{
		attributes,
		droppedAttributesCount,
		&SliceField{
			// Hide accessors for this field from 1.x public API since the proto field is experimental.
			// It's available via the xpdata/entity.ResourceEntityRefs.
			hideAccessors:   true,
			originFieldName: "EntityRefs",
			returnSlice:     entityRefSlice,
		},
	},
}

var resourceField = &MessageField{
	fieldName:     "Resource",
	returnMessage: resource,
}

var byteSlice = &primitiveSliceStruct{
	structName:           "ByteSlice",
	packageName:          "pcommon",
	itemType:             "byte",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var float64Slice = &primitiveSliceStruct{
	structName:           "Float64Slice",
	packageName:          "pcommon",
	itemType:             "float64",
	testOrigVal:          "1.1, 2.2, 3.3",
	testInterfaceOrigVal: []any{1.1, 2.2, 3.3},
	testSetVal:           "5.5",
	testNewVal:           "1.1, 5.5, 3.3",
}

var uInt64Slice = &primitiveSliceStruct{
	structName:           "UInt64Slice",
	packageName:          "pcommon",
	itemType:             "uint64",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var int64Slice = &primitiveSliceStruct{
	structName:           "Int64Slice",
	packageName:          "pcommon",
	itemType:             "int64",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var int32Slice = &primitiveSliceStruct{
	structName:           "Int32Slice",
	packageName:          "pcommon",
	itemType:             "int32",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var stringSlice = &primitiveSliceStruct{
	structName:           "StringSlice",
	packageName:          "pcommon",
	itemType:             "string",
	testOrigVal:          `"a", "b", "c"`,
	testInterfaceOrigVal: []any{`"a"`, `"b"`, `"c"`},
	testSetVal:           `"d"`,
	testNewVal:           `"a", "d", "c"`,
}
