// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigAttributeUnitSlice(t *testing.T) {
	src := []*otlpprofiles.AttributeUnit{}
	dest := []*otlpprofiles.AttributeUnit{}
	// Test CopyTo empty
	dest = CopyOrigAttributeUnitSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.AttributeUnit{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestAttributeUnitSlice()
	dest = CopyOrigAttributeUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAttributeUnitSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigAttributeUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAttributeUnitSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigAttributeUnitSlice(dest, []*otlpprofiles.AttributeUnit{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigAttributeUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestAttributeUnitSlice(), dest)
}
