// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"math"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExponentialHistogramDataPoint(dest, src *otlpmetrics.ExponentialHistogramDataPoint) {
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Count = src.Count
	if srcSum, ok := src.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum); ok {
		destSum, ok := dest.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum)
		if !ok {
			destSum = &otlpmetrics.ExponentialHistogramDataPoint_Sum{}
			dest.Sum_ = destSum
		}
		destSum.Sum = srcSum.Sum
	} else {
		dest.Sum_ = nil
	}
	dest.Scale = src.Scale
	dest.ZeroCount = src.ZeroCount
	CopyOrigExponentialHistogramDataPoint_Buckets(&dest.Positive, &src.Positive)
	CopyOrigExponentialHistogramDataPoint_Buckets(&dest.Negative, &src.Negative)
	dest.Flags = src.Flags
	dest.Exemplars = CopyOrigExemplarSlice(dest.Exemplars, src.Exemplars)
	if srcMin, ok := src.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min); ok {
		destMin, ok := dest.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min)
		if !ok {
			destMin = &otlpmetrics.ExponentialHistogramDataPoint_Min{}
			dest.Min_ = destMin
		}
		destMin.Min = srcMin.Min
	} else {
		dest.Min_ = nil
	}
	if srcMax, ok := src.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max); ok {
		destMax, ok := dest.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max)
		if !ok {
			destMax = &otlpmetrics.ExponentialHistogramDataPoint_Max{}
			dest.Max_ = destMax
		}
		destMax.Max = srcMax.Max
	} else {
		dest.Max_ = nil
	}
	dest.ZeroThreshold = src.ZeroThreshold
}

func FillOrigTestExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint) {
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.StartTimeUnixNano = 1234567890
	orig.TimeUnixNano = 1234567890
	orig.Count = uint64(13)
	orig.Sum_ = &otlpmetrics.ExponentialHistogramDataPoint_Sum{Sum: float64(3.1415926)}
	orig.Scale = int32(13)
	orig.ZeroCount = uint64(13)
	FillOrigTestExponentialHistogramDataPoint_Buckets(&orig.Positive)
	FillOrigTestExponentialHistogramDataPoint_Buckets(&orig.Negative)
	orig.Flags = 1
	orig.Exemplars = GenerateOrigTestExemplarSlice()
	orig.Min_ = &otlpmetrics.ExponentialHistogramDataPoint_Min{Min: float64(3.1415926)}
	orig.Max_ = &otlpmetrics.ExponentialHistogramDataPoint_Max{Max: float64(3.1415926)}
	orig.ZeroThreshold = float64(3.1415926)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig.Sum_ != nil {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum).Sum)
	}
	if orig.Scale != int32(0) {
		dest.WriteObjectField("scale")
		dest.WriteInt32(orig.Scale)
	}
	if orig.ZeroCount != uint64(0) {
		dest.WriteObjectField("zeroCount")
		dest.WriteUint64(orig.ZeroCount)
	}
	dest.WriteObjectField("positive")
	MarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, dest)
	dest.WriteObjectField("negative")
	MarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, dest)
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		MarshalJSONOrigExemplar(&orig.Exemplars[0], dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			MarshalJSONOrigExemplar(&orig.Exemplars[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Min_ != nil {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min).Min)
	}
	if orig.Max_ != nil {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max).Max)
	}
	if orig.ZeroThreshold != float64(0) {
		dest.WriteObjectField("zeroThreshold")
		dest.WriteFloat64(orig.ZeroThreshold)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExponentialHistogramDataPoint unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "attributes":
			orig.Attributes = UnmarshalJSONOrigKeyValueSlice(iter)
		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			orig.Sum_ = &otlpmetrics.ExponentialHistogramDataPoint_Sum{Sum: iter.ReadFloat64()}
		case "scale":
			orig.Scale = iter.ReadInt32()
		case "zeroCount", "zero_count":
			orig.ZeroCount = iter.ReadUint64()
		case "positive":
			UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, iter)
		case "negative":
			UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "exemplars":
			orig.Exemplars = UnmarshalJSONOrigExemplarSlice(iter)
		case "min":
			orig.Min_ = &otlpmetrics.ExponentialHistogramDataPoint_Min{Min: iter.ReadFloat64()}
		case "max":
			orig.Max_ = &otlpmetrics.ExponentialHistogramDataPoint_Max{Max: iter.ReadFloat64()}
		case "zeroThreshold", "zero_threshold":
			orig.ZeroThreshold = iter.ReadFloat64()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint) int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.Count != 0 {
		n += 9
	}
	if orig.Sum_ != nil {
		n += 9
	}
	if orig.Scale != 0 {
		n += 1 + proto.Soz(uint64(orig.Scale))
	}
	if orig.ZeroCount != 0 {
		n += 9
	}
	l = SizeProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Positive)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Negative)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	for i := range orig.Exemplars {
		l = SizeProtoOrigExemplar(&orig.Exemplars[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Min_ != nil {
		n += 9
	}
	if orig.Max_ != nil {
		n += 9
	}
	if orig.ZeroThreshold != 0 {
		n += 9
	}
	return n
}

func MarshalProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.Attributes {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig.Sum_ != nil {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum).Sum))
		pos--
		buf[pos] = 0x29

	}
	if orig.Scale != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Scale)<<1)^uint32(orig.Scale>>31)))
		pos--
		buf[pos] = 0x30
	}
	if orig.ZeroCount != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ZeroCount))
		pos--
		buf[pos] = 0x39
	}

	l = MarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x42

	l = MarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	for i := range orig.Exemplars {
		l = MarshalProtoOrigExemplar(&orig.Exemplars[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig.Min_ != nil {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min).Min))
		pos--
		buf[pos] = 0x61

	}
	if orig.Max_ != nil {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max).Max))
		pos--
		buf[pos] = 0x69

	}
	if orig.ZeroThreshold != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ZeroThreshold))
		pos--
		buf[pos] = 0x71
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, buf []byte) error {
	return orig.Unmarshal(buf)
}
