// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExponentialHistogramDataPoint_Buckets(dest, src *otlpmetrics.ExponentialHistogramDataPoint_Buckets) {
	dest.Offset = src.Offset
	dest.BucketCounts = CopyOrigUint64Slice(dest.BucketCounts, src.BucketCounts)
}

func FillOrigTestExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets) {
	orig.Offset = int32(13)
	orig.BucketCounts = GenerateOrigTestUint64Slice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Offset != int32(0) {
		dest.WriteObjectField("offset")
		dest.WriteInt32(orig.Offset)
	}
	if len(orig.BucketCounts) > 0 {
		dest.WriteObjectField("bucketCounts")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.BucketCounts[0])
		for i := 1; i < len(orig.BucketCounts); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.BucketCounts[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExponentialHistogramDataPointBuckets unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "offset":
			orig.Offset = iter.ReadInt32()
		case "bucketCounts", "bucket_counts":
			orig.BucketCounts = UnmarshalJSONOrigUint64Slice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets) int {
	var n int
	var l int
	_ = l
	if orig.Offset != 0 {
		n += 1 + proto.Soz(uint64(orig.Offset))
	}
	if len(orig.BucketCounts) > 0 {
		l = 0
		for _, e := range orig.BucketCounts {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Offset != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Offset)<<1)^uint32(orig.Offset>>31)))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.BucketCounts[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, buf []byte) error {
	return orig.Unmarshal(buf)
}
