// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExponentialHistogramDataPoint_Buckets(t *testing.T) {
	src := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
	dest := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
	CopyOrigExponentialHistogramDataPoint_Buckets(dest, src)
	assert.Equal(t, &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}, dest)
	FillOrigTestExponentialHistogramDataPoint_Buckets(src)
	CopyOrigExponentialHistogramDataPoint_Buckets(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogramDataPoint_BucketsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
	UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogramDataPoint_Buckets() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExponentialHistogramDataPoint_Buckets(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
			UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogramDataPoint_Buckets() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExponentialHistogramDataPoint_Buckets(src))
			gotSize := MarshalProtoOrigExponentialHistogramDataPoint_Buckets(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
			require.NoError(t, UnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExponentialHistogramDataPoint_Buckets() map[string]*otlpmetrics.ExponentialHistogramDataPoint_Buckets {
	return map[string]*otlpmetrics.ExponentialHistogramDataPoint_Buckets{
		"empty": {},
		"fill_test": func() *otlpmetrics.ExponentialHistogramDataPoint_Buckets {
			src := &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
			FillOrigTestExponentialHistogramDataPoint_Buckets(src)
			return src
		}(),
	}
}
