// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExportLogsPartialSuccess(dest, src *otlpcollectorlog.ExportLogsPartialSuccess) {
	dest.RejectedLogRecords = src.RejectedLogRecords
	dest.ErrorMessage = src.ErrorMessage
}

func FillOrigTestExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess) {
	orig.RejectedLogRecords = int64(13)
	orig.ErrorMessage = "test_errormessage"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedLogRecords != int64(0) {
		dest.WriteObjectField("rejectedLogRecords")
		dest.WriteInt64(orig.RejectedLogRecords)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportPartialSuccess unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "rejectedLogRecords", "rejected_log_records":
			orig.RejectedLogRecords = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess) int {
	var n int
	var l int
	_ = l
	if orig.RejectedLogRecords != 0 {
		n += 1 + proto.Sov(uint64(orig.RejectedLogRecords))
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedLogRecords != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedLogRecords))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportLogsPartialSuccess(orig *otlpcollectorlog.ExportLogsPartialSuccess, buf []byte) error {
	return orig.Unmarshal(buf)
}
