// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsServiceRequest(t *testing.T) {
	src := &otlpcollectorlog.ExportLogsServiceRequest{}
	dest := &otlpcollectorlog.ExportLogsServiceRequest{}
	CopyOrigExportLogsServiceRequest(dest, src)
	assert.Equal(t, &otlpcollectorlog.ExportLogsServiceRequest{}, dest)
	FillOrigTestExportLogsServiceRequest(src)
	CopyOrigExportLogsServiceRequest(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorlog.ExportLogsServiceRequest{}
	UnmarshalJSONOrigExportLogsServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorlog.ExportLogsServiceRequest{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportLogsServiceRequest(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorlog.ExportLogsServiceRequest{}
			UnmarshalJSONOrigExportLogsServiceRequest(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceRequest(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsServiceRequest(src))
			gotSize := MarshalProtoOrigExportLogsServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorlog.ExportLogsServiceRequest{}
			require.NoError(t, UnmarshalProtoOrigExportLogsServiceRequest(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportLogsServiceRequest() map[string]*otlpcollectorlog.ExportLogsServiceRequest {
	return map[string]*otlpcollectorlog.ExportLogsServiceRequest{
		"empty": {},
		"fill_test": func() *otlpcollectorlog.ExportLogsServiceRequest {
			src := &otlpcollectorlog.ExportLogsServiceRequest{}
			FillOrigTestExportLogsServiceRequest(src)
			return src
		}(),
	}
}
