// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Profiles struct {
	orig  *otlpcollectorprofile.ExportProfilesServiceRequest
	state *State
}

func GetOrigProfiles(ms Profiles) *otlpcollectorprofile.ExportProfilesServiceRequest {
	return ms.orig
}

func GetProfilesState(ms Profiles) *State {
	return ms.state
}

func NewProfiles(orig *otlpcollectorprofile.ExportProfilesServiceRequest, state *State) Profiles {
	return Profiles{orig: orig, state: state}
}

func GenerateTestProfiles() Profiles {
	orig := otlpcollectorprofile.ExportProfilesServiceRequest{}
	FillOrigTestExportProfilesServiceRequest(&orig)
	state := StateMutable
	return NewProfiles(&orig, &state)
}

func CopyOrigExportProfilesServiceRequest(dest, src *otlpcollectorprofile.ExportProfilesServiceRequest) {
	dest.ResourceProfiles = CopyOrigResourceProfilesSlice(dest.ResourceProfiles, src.ResourceProfiles)
	CopyOrigProfilesDictionary(&dest.Dictionary, &src.Dictionary)
}

func FillOrigTestExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest) {
	orig.ResourceProfiles = GenerateOrigTestResourceProfilesSlice()
	FillOrigTestProfilesDictionary(&orig.Dictionary)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceProfiles) > 0 {
		dest.WriteObjectField("resourceProfiles")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceProfiles(orig.ResourceProfiles[0], dest)
		for i := 1; i < len(orig.ResourceProfiles); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceProfiles(orig.ResourceProfiles[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectField("dictionary")
	MarshalJSONOrigProfilesDictionary(&orig.Dictionary, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigProfiles unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resourceProfiles", "resource_profiles":
			orig.ResourceProfiles = UnmarshalJSONOrigResourceProfilesSlice(iter)
		case "dictionary":
			UnmarshalJSONOrigProfilesDictionary(&orig.Dictionary, iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceProfiles {
		l = SizeProtoOrigResourceProfiles(orig.ResourceProfiles[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigProfilesDictionary(&orig.Dictionary)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.ResourceProfiles {
		l = MarshalProtoOrigResourceProfiles(orig.ResourceProfiles[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}

	l = MarshalProtoOrigProfilesDictionary(&orig.Dictionary, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func UnmarshalProtoOrigExportProfilesServiceRequest(orig *otlpcollectorprofile.ExportProfilesServiceRequest, buf []byte) error {
	return orig.Unmarshal(buf)
}
