// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectorprofile "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExportProfilesServiceResponse(dest, src *otlpcollectorprofile.ExportProfilesServiceResponse) {
	CopyOrigExportProfilesPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)
}

func FillOrigTestExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse) {
	FillOrigTestExportProfilesPartialSuccess(&orig.PartialSuccess)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	MarshalJSONOrigExportProfilesPartialSuccess(&orig.PartialSuccess, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportResponse unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "partialSuccess", "partial_success":
			UnmarshalJSONOrigExportProfilesPartialSuccess(&orig.PartialSuccess, iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigExportProfilesPartialSuccess(&orig.PartialSuccess)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigExportProfilesPartialSuccess(&orig.PartialSuccess, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func UnmarshalProtoOrigExportProfilesServiceResponse(orig *otlpcollectorprofile.ExportProfilesServiceResponse, buf []byte) error {
	return orig.Unmarshal(buf)
}
