// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportTracePartialSuccess(t *testing.T) {
	src := &otlpcollectortrace.ExportTracePartialSuccess{}
	dest := &otlpcollectortrace.ExportTracePartialSuccess{}
	CopyOrigExportTracePartialSuccess(dest, src)
	assert.Equal(t, &otlpcollectortrace.ExportTracePartialSuccess{}, dest)
	FillOrigTestExportTracePartialSuccess(src)
	CopyOrigExportTracePartialSuccess(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTracePartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectortrace.ExportTracePartialSuccess{}
	UnmarshalJSONOrigExportTracePartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectortrace.ExportTracePartialSuccess{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportTracePartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportTracePartialSuccess(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectortrace.ExportTracePartialSuccess{}
			UnmarshalJSONOrigExportTracePartialSuccess(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportTracePartialSuccess(t *testing.T) {
	for name, src := range getEncodingTestValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportTracePartialSuccess(src))
			gotSize := MarshalProtoOrigExportTracePartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectortrace.ExportTracePartialSuccess{}
			require.NoError(t, UnmarshalProtoOrigExportTracePartialSuccess(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportTracePartialSuccess() map[string]*otlpcollectortrace.ExportTracePartialSuccess {
	return map[string]*otlpcollectortrace.ExportTracePartialSuccess{
		"empty": {},
		"fill_test": func() *otlpcollectortrace.ExportTracePartialSuccess {
			src := &otlpcollectortrace.ExportTracePartialSuccess{}
			FillOrigTestExportTracePartialSuccess(src)
			return src
		}(),
	}
}
