// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type Float64Slice struct {
	orig  *[]float64
	state *State
}

func GetOrigFloat64Slice(ms Float64Slice) *[]float64 {
	return ms.orig
}

func GetFloat64SliceState(ms Float64Slice) *State {
	return ms.state
}

func NewFloat64Slice(orig *[]float64, state *State) Float64Slice {
	return Float64Slice{orig: orig, state: state}
}

func GenerateTestFloat64Slice() Float64Slice {
	orig := GenerateOrigTestFloat64Slice()
	state := StateMutable
	return NewFloat64Slice(&orig, &state)
}

func CopyOrigFloat64Slice(dst, src []float64) []float64 {
	return append(dst[:0], src...)
}

func GenerateOrigTestFloat64Slice() []float64 {
	return []float64{1.1, 2.2, 3.3}
}

// UnmarshalJSONOrigFloat64Slice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigFloat64Slice(iter *json.Iterator) []float64 {
	var orig []float64
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, iter.ReadFloat64())
		return true
	})
	return orig
}
