// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type Int32Slice struct {
	orig  *[]int32
	state *State
}

func GetOrigInt32Slice(ms Int32Slice) *[]int32 {
	return ms.orig
}

func GetInt32SliceState(ms Int32Slice) *State {
	return ms.state
}

func NewInt32Slice(orig *[]int32, state *State) Int32Slice {
	return Int32Slice{orig: orig, state: state}
}

func GenerateTestInt32Slice() Int32Slice {
	orig := GenerateOrigTestInt32Slice()
	state := StateMutable
	return NewInt32Slice(&orig, &state)
}

func CopyOrigInt32Slice(dst, src []int32) []int32 {
	return append(dst[:0], src...)
}

func GenerateOrigTestInt32Slice() []int32 {
	return []int32{1, 2, 3}
}

// UnmarshalJSONOrigInt32Slice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigInt32Slice(iter *json.Iterator) []int32 {
	var orig []int32
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, iter.ReadInt32())
		return true
	})
	return orig
}
