// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigKeyValue(t *testing.T) {
	src := &v1.KeyValue{}
	dest := &v1.KeyValue{}
	CopyOrigKeyValue(dest, src)
	assert.Equal(t, &v1.KeyValue{}, dest)
	FillOrigTestKeyValue(src)
	CopyOrigKeyValue(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigKeyValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &v1.KeyValue{}
	UnmarshalJSONOrigKeyValue(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &v1.KeyValue{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigKeyValue(t *testing.T) {
	for name, src := range getEncodingTestValuesKeyValue() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigKeyValue(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &v1.KeyValue{}
			UnmarshalJSONOrigKeyValue(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigKeyValue(t *testing.T) {
	for name, src := range getEncodingTestValuesKeyValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigKeyValue(src))
			gotSize := MarshalProtoOrigKeyValue(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &v1.KeyValue{}
			require.NoError(t, UnmarshalProtoOrigKeyValue(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesKeyValue() map[string]*v1.KeyValue {
	return map[string]*v1.KeyValue{
		"empty": {},
		"fill_test": func() *v1.KeyValue {
			src := &v1.KeyValue{}
			FillOrigTestKeyValue(src)
			return src
		}(),
	}
}
