// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"math"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigNumberDataPoint(dest, src *otlpmetrics.NumberDataPoint) {
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	switch t := src.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		dest.Value = &otlpmetrics.NumberDataPoint_AsDouble{AsDouble: t.AsDouble}
	case *otlpmetrics.NumberDataPoint_AsInt:
		dest.Value = &otlpmetrics.NumberDataPoint_AsInt{AsInt: t.AsInt}
	}
	dest.Exemplars = CopyOrigExemplarSlice(dest.Exemplars, src.Exemplars)
	dest.Flags = src.Flags
}

func FillOrigTestNumberDataPoint(orig *otlpmetrics.NumberDataPoint) {
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.StartTimeUnixNano = 1234567890
	orig.TimeUnixNano = 1234567890
	orig.Value = &otlpmetrics.NumberDataPoint_AsDouble{AsDouble: float64(3.1415926)}
	orig.Exemplars = GenerateOrigTestExemplarSlice()
	orig.Flags = 1
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	switch orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		dest.WriteObjectField("asDouble")
		dest.WriteFloat64(orig.Value.(*otlpmetrics.NumberDataPoint_AsDouble).AsDouble)
	case *otlpmetrics.NumberDataPoint_AsInt:
		dest.WriteObjectField("asInt")
		dest.WriteInt64(orig.Value.(*otlpmetrics.NumberDataPoint_AsInt).AsInt)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		MarshalJSONOrigExemplar(&orig.Exemplars[0], dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			MarshalJSONOrigExemplar(&orig.Exemplars[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigNumberDataPoint unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "attributes":
			orig.Attributes = UnmarshalJSONOrigKeyValueSlice(iter)
		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()

		case "asDouble", "as_double":
			orig.Value = &otlpmetrics.NumberDataPoint_AsDouble{
				AsDouble: iter.ReadFloat64(),
			}
		case "asInt", "as_int":
			orig.Value = &otlpmetrics.NumberDataPoint_AsInt{
				AsInt: iter.ReadInt64(),
			}
		case "exemplars":
			orig.Exemplars = UnmarshalJSONOrigExemplarSlice(iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint) int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	switch orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		n += 9
	case *otlpmetrics.NumberDataPoint_AsInt:
		n += 9
	}
	for i := range orig.Exemplars {
		l = SizeProtoOrigExemplar(&orig.Exemplars[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	return n
}

func MarshalProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.Attributes {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	switch orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Value.(*otlpmetrics.NumberDataPoint_AsDouble).AsDouble))
		pos--
		buf[pos] = 0x21

	case *otlpmetrics.NumberDataPoint_AsInt:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Value.(*otlpmetrics.NumberDataPoint_AsInt).AsInt))
		pos--
		buf[pos] = 0x31

	}
	for i := range orig.Exemplars {
		l = MarshalProtoOrigExemplar(&orig.Exemplars[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x40
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, buf []byte) error {
	return orig.Unmarshal(buf)
}
