// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigProfilesDictionary(dest, src *otlpprofiles.ProfilesDictionary) {
	dest.MappingTable = CopyOrigMappingSlice(dest.MappingTable, src.MappingTable)
	dest.LocationTable = CopyOrigLocationSlice(dest.LocationTable, src.LocationTable)
	dest.FunctionTable = CopyOrigFunctionSlice(dest.FunctionTable, src.FunctionTable)
	dest.LinkTable = CopyOrigLinkSlice(dest.LinkTable, src.LinkTable)
	dest.StringTable = CopyOrigStringSlice(dest.StringTable, src.StringTable)
	dest.AttributeTable = CopyOrigKeyValueSlice(dest.AttributeTable, src.AttributeTable)
	dest.AttributeUnits = CopyOrigAttributeUnitSlice(dest.AttributeUnits, src.AttributeUnits)
}

func FillOrigTestProfilesDictionary(orig *otlpprofiles.ProfilesDictionary) {
	orig.MappingTable = GenerateOrigTestMappingSlice()
	orig.LocationTable = GenerateOrigTestLocationSlice()
	orig.FunctionTable = GenerateOrigTestFunctionSlice()
	orig.LinkTable = GenerateOrigTestLinkSlice()
	orig.StringTable = GenerateOrigTestStringSlice()
	orig.AttributeTable = GenerateOrigTestKeyValueSlice()
	orig.AttributeUnits = GenerateOrigTestAttributeUnitSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.MappingTable) > 0 {
		dest.WriteObjectField("mappingTable")
		dest.WriteArrayStart()
		MarshalJSONOrigMapping(orig.MappingTable[0], dest)
		for i := 1; i < len(orig.MappingTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigMapping(orig.MappingTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LocationTable) > 0 {
		dest.WriteObjectField("locationTable")
		dest.WriteArrayStart()
		MarshalJSONOrigLocation(orig.LocationTable[0], dest)
		for i := 1; i < len(orig.LocationTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigLocation(orig.LocationTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.FunctionTable) > 0 {
		dest.WriteObjectField("functionTable")
		dest.WriteArrayStart()
		MarshalJSONOrigFunction(orig.FunctionTable[0], dest)
		for i := 1; i < len(orig.FunctionTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigFunction(orig.FunctionTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LinkTable) > 0 {
		dest.WriteObjectField("linkTable")
		dest.WriteArrayStart()
		MarshalJSONOrigLink(orig.LinkTable[0], dest)
		for i := 1; i < len(orig.LinkTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigLink(orig.LinkTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.StringTable) > 0 {
		dest.WriteObjectField("stringTable")
		dest.WriteArrayStart()
		dest.WriteString(orig.StringTable[0])
		for i := 1; i < len(orig.StringTable); i++ {
			dest.WriteMore()
			dest.WriteString(orig.StringTable[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeTable) > 0 {
		dest.WriteObjectField("attributeTable")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.AttributeTable[0], dest)
		for i := 1; i < len(orig.AttributeTable); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.AttributeTable[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeUnits) > 0 {
		dest.WriteObjectField("attributeUnits")
		dest.WriteArrayStart()
		MarshalJSONOrigAttributeUnit(orig.AttributeUnits[0], dest)
		for i := 1; i < len(orig.AttributeUnits); i++ {
			dest.WriteMore()
			MarshalJSONOrigAttributeUnit(orig.AttributeUnits[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigProfilesDictionary unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "mappingTable", "mapping_table":
			orig.MappingTable = UnmarshalJSONOrigMappingSlice(iter)
		case "locationTable", "location_table":
			orig.LocationTable = UnmarshalJSONOrigLocationSlice(iter)
		case "functionTable", "function_table":
			orig.FunctionTable = UnmarshalJSONOrigFunctionSlice(iter)
		case "linkTable", "link_table":
			orig.LinkTable = UnmarshalJSONOrigLinkSlice(iter)
		case "stringTable", "string_table":
			orig.StringTable = UnmarshalJSONOrigStringSlice(iter)
		case "attributeTable", "attribute_table":
			orig.AttributeTable = UnmarshalJSONOrigKeyValueSlice(iter)
		case "attributeUnits", "attribute_units":
			orig.AttributeUnits = UnmarshalJSONOrigAttributeUnitSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary) int {
	var n int
	var l int
	_ = l
	for i := range orig.MappingTable {
		l = SizeProtoOrigMapping(orig.MappingTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LocationTable {
		l = SizeProtoOrigLocation(orig.LocationTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.FunctionTable {
		l = SizeProtoOrigFunction(orig.FunctionTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LinkTable {
		l = SizeProtoOrigLink(orig.LinkTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for _, s := range orig.StringTable {
		l = len(s)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.AttributeTable {
		l = SizeProtoOrigKeyValue(&orig.AttributeTable[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.AttributeUnits {
		l = SizeProtoOrigAttributeUnit(orig.AttributeUnits[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.MappingTable {
		l = MarshalProtoOrigMapping(orig.MappingTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	for i := range orig.LocationTable {
		l = MarshalProtoOrigLocation(orig.LocationTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := range orig.FunctionTable {
		l = MarshalProtoOrigFunction(orig.FunctionTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := range orig.LinkTable {
		l = MarshalProtoOrigLink(orig.LinkTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	for i := len(orig.StringTable) - 1; i >= 0; i-- {
		l = len(orig.StringTable[i])
		pos -= l
		copy(buf[pos:], orig.StringTable[i])
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	for i := range orig.AttributeTable {
		l = MarshalProtoOrigKeyValue(&orig.AttributeTable[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	for i := range orig.AttributeUnits {
		l = MarshalProtoOrigAttributeUnit(orig.AttributeUnits[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigProfilesDictionary(orig *otlpprofiles.ProfilesDictionary, buf []byte) error {
	return orig.Unmarshal(buf)
}
