// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigResourceLogsSlice(dest, src []*otlplogs.ResourceLogs) []*otlplogs.ResourceLogs {
	var newDest []*otlplogs.ResourceLogs
	if cap(dest) < len(src) {
		newDest = make([]*otlplogs.ResourceLogs, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlplogs.ResourceLogs{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlplogs.ResourceLogs{}
		}
	}
	for i := range src {
		CopyOrigResourceLogs(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestResourceLogsSlice() []*otlplogs.ResourceLogs {
	orig := make([]*otlplogs.ResourceLogs, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlplogs.ResourceLogs{}
		FillOrigTestResourceLogs(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigResourceLogsSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigResourceLogsSlice(iter *json.Iterator) []*otlplogs.ResourceLogs {
	var orig []*otlplogs.ResourceLogs
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlplogs.ResourceLogs{})
		UnmarshalJSONOrigResourceLogs(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
