// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigResourceMetrics(dest, src *otlpmetrics.ResourceMetrics) {
	CopyOrigResource(&dest.Resource, &src.Resource)
	dest.ScopeMetrics = CopyOrigScopeMetricsSlice(dest.ScopeMetrics, src.ScopeMetrics)
	dest.SchemaUrl = src.SchemaUrl
}

func FillOrigTestResourceMetrics(orig *otlpmetrics.ResourceMetrics) {
	FillOrigTestResource(&orig.Resource)
	orig.ScopeMetrics = GenerateOrigTestScopeMetricsSlice()
	orig.SchemaUrl = "test_schemaurl"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigResourceMetrics(orig *otlpmetrics.ResourceMetrics, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	MarshalJSONOrigResource(&orig.Resource, dest)
	if len(orig.ScopeMetrics) > 0 {
		dest.WriteObjectField("scopeMetrics")
		dest.WriteArrayStart()
		MarshalJSONOrigScopeMetrics(orig.ScopeMetrics[0], dest)
		for i := 1; i < len(orig.ScopeMetrics); i++ {
			dest.WriteMore()
			MarshalJSONOrigScopeMetrics(orig.ScopeMetrics[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigResourceMetrics unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigResourceMetrics(orig *otlpmetrics.ResourceMetrics, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resource":
			UnmarshalJSONOrigResource(&orig.Resource, iter)
		case "scopeMetrics", "scope_metrics":
			orig.ScopeMetrics = UnmarshalJSONOrigScopeMetricsSlice(iter)
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigResourceMetrics(orig *otlpmetrics.ResourceMetrics) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigResource(&orig.Resource)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeMetrics {
		l = SizeProtoOrigScopeMetrics(orig.ScopeMetrics[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigResourceMetrics(orig *otlpmetrics.ResourceMetrics, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigResource(&orig.Resource, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := range orig.ScopeMetrics {
		l = MarshalProtoOrigScopeMetrics(orig.ScopeMetrics[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigResourceMetrics(orig *otlpmetrics.ResourceMetrics, buf []byte) error {
	return orig.Unmarshal(buf)
}
