// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigResourceMetricsSlice(t *testing.T) {
	src := []*otlpmetrics.ResourceMetrics{}
	dest := []*otlpmetrics.ResourceMetrics{}
	// Test CopyTo empty
	dest = CopyOrigResourceMetricsSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.ResourceMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestResourceMetricsSlice()
	dest = CopyOrigResourceMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigResourceMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceMetricsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigResourceMetricsSlice(dest, []*otlpmetrics.ResourceMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigResourceMetricsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceMetricsSlice(), dest)
}
