// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigSample(dest, src *otlpprofiles.Sample) {
	dest.LocationsStartIndex = src.LocationsStartIndex
	dest.LocationsLength = src.LocationsLength
	dest.Value = CopyOrigInt64Slice(dest.Value, src.Value)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
	if srcLinkIndex, ok := src.LinkIndex_.(*otlpprofiles.Sample_LinkIndex); ok {
		destLinkIndex, ok := dest.LinkIndex_.(*otlpprofiles.Sample_LinkIndex)
		if !ok {
			destLinkIndex = &otlpprofiles.Sample_LinkIndex{}
			dest.LinkIndex_ = destLinkIndex
		}
		destLinkIndex.LinkIndex = srcLinkIndex.LinkIndex
	} else {
		dest.LinkIndex_ = nil
	}
	dest.TimestampsUnixNano = CopyOrigUint64Slice(dest.TimestampsUnixNano, src.TimestampsUnixNano)
}

func FillOrigTestSample(orig *otlpprofiles.Sample) {
	orig.LocationsStartIndex = int32(13)
	orig.LocationsLength = int32(13)
	orig.Value = GenerateOrigTestInt64Slice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	orig.LinkIndex_ = &otlpprofiles.Sample_LinkIndex{LinkIndex: int32(13)}
	orig.TimestampsUnixNano = GenerateOrigTestUint64Slice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSample(orig *otlpprofiles.Sample, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.LocationsStartIndex != int32(0) {
		dest.WriteObjectField("locationsStartIndex")
		dest.WriteInt32(orig.LocationsStartIndex)
	}
	if orig.LocationsLength != int32(0) {
		dest.WriteObjectField("locationsLength")
		dest.WriteInt32(orig.LocationsLength)
	}
	if len(orig.Value) > 0 {
		dest.WriteObjectField("value")
		dest.WriteArrayStart()
		dest.WriteInt64(orig.Value[0])
		for i := 1; i < len(orig.Value); i++ {
			dest.WriteMore()
			dest.WriteInt64(orig.Value[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.LinkIndex_ != nil {
		dest.WriteObjectField("linkIndex")
		dest.WriteInt32(orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex).LinkIndex)
	}
	if len(orig.TimestampsUnixNano) > 0 {
		dest.WriteObjectField("timestampsUnixNano")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.TimestampsUnixNano[0])
		for i := 1; i < len(orig.TimestampsUnixNano); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.TimestampsUnixNano[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSample unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSample(orig *otlpprofiles.Sample, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "locationsStartIndex", "locations_start_index":
			orig.LocationsStartIndex = iter.ReadInt32()
		case "locationsLength", "locations_length":
			orig.LocationsLength = iter.ReadInt32()
		case "value":
			orig.Value = UnmarshalJSONOrigInt64Slice(iter)
		case "attributeIndices", "attribute_indices":
			orig.AttributeIndices = UnmarshalJSONOrigInt32Slice(iter)
		case "linkIndex", "link_index":
			orig.LinkIndex_ = &otlpprofiles.Sample_LinkIndex{LinkIndex: iter.ReadInt32()}
		case "timestampsUnixNano", "timestamps_unix_nano":
			orig.TimestampsUnixNano = UnmarshalJSONOrigUint64Slice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigSample(orig *otlpprofiles.Sample) int {
	var n int
	var l int
	_ = l
	if orig.LocationsStartIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.LocationsStartIndex))
	}
	if orig.LocationsLength != 0 {
		n += 1 + proto.Sov(uint64(orig.LocationsLength))
	}
	if len(orig.Value) > 0 {
		l = 0
		for _, e := range orig.Value {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.LinkIndex_ != nil {
		n += 1 + proto.Sov(uint64(orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex).LinkIndex))
	}
	if len(orig.TimestampsUnixNano) > 0 {
		l = 0
		for _, e := range orig.TimestampsUnixNano {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.LocationsStartIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationsStartIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.LocationsLength != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationsLength))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.Value)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.Value[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x1a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x22
	}
	if orig.LinkIndex_ != nil {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LinkIndex_.(*otlpprofiles.Sample_LinkIndex).LinkIndex))
		pos--
		buf[pos] = 0x28

	}
	l = len(orig.TimestampsUnixNano)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.TimestampsUnixNano[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x32
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) error {
	return orig.Unmarshal(buf)
}
