// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigSampleSlice(dest, src []*otlpprofiles.Sample) []*otlpprofiles.Sample {
	var newDest []*otlpprofiles.Sample
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Sample, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Sample{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Sample{}
		}
	}
	for i := range src {
		CopyOrigSample(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSampleSlice() []*otlpprofiles.Sample {
	orig := make([]*otlpprofiles.Sample, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpprofiles.Sample{}
		FillOrigTestSample(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigSampleSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSampleSlice(iter *json.Iterator) []*otlpprofiles.Sample {
	var orig []*otlpprofiles.Sample
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpprofiles.Sample{})
		UnmarshalJSONOrigSample(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
