// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSpan_Link(t *testing.T) {
	src := &otlptrace.Span_Link{}
	dest := &otlptrace.Span_Link{}
	CopyOrigSpan_Link(dest, src)
	assert.Equal(t, &otlptrace.Span_Link{}, dest)
	FillOrigTestSpan_Link(src)
	CopyOrigSpan_Link(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan_LinkUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.Span_Link{}
	UnmarshalJSONOrigSpan_Link(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.Span_Link{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSpan_Link(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan_Link() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSpan_Link(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.Span_Link{}
			UnmarshalJSONOrigSpan_Link(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSpan_Link(t *testing.T) {
	for name, src := range getEncodingTestValuesSpan_Link() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSpan_Link(src))
			gotSize := MarshalProtoOrigSpan_Link(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.Span_Link{}
			require.NoError(t, UnmarshalProtoOrigSpan_Link(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSpan_Link() map[string]*otlptrace.Span_Link {
	return map[string]*otlptrace.Span_Link{
		"empty": {},
		"fill_test": func() *otlptrace.Span_Link {
			src := &otlptrace.Span_Link{}
			FillOrigTestSpan_Link(src)
			return src
		}(),
	}
}
