// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigStatus(t *testing.T) {
	src := &otlptrace.Status{}
	dest := &otlptrace.Status{}
	CopyOrigStatus(dest, src)
	assert.Equal(t, &otlptrace.Status{}, dest)
	FillOrigTestStatus(src)
	CopyOrigStatus(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigStatusUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlptrace.Status{}
	UnmarshalJSONOrigStatus(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlptrace.Status{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigStatus(t *testing.T) {
	for name, src := range getEncodingTestValuesStatus() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigStatus(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlptrace.Status{}
			UnmarshalJSONOrigStatus(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigStatus(t *testing.T) {
	for name, src := range getEncodingTestValuesStatus() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigStatus(src))
			gotSize := MarshalProtoOrigStatus(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlptrace.Status{}
			require.NoError(t, UnmarshalProtoOrigStatus(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesStatus() map[string]*otlptrace.Status {
	return map[string]*otlptrace.Status{
		"empty": {},
		"fill_test": func() *otlptrace.Status {
			src := &otlptrace.Status{}
			FillOrigTestStatus(src)
			return src
		}(),
	}
}
