// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSum(t *testing.T) {
	src := &otlpmetrics.Sum{}
	dest := &otlpmetrics.Sum{}
	CopyOrigSum(dest, src)
	assert.Equal(t, &otlpmetrics.Sum{}, dest)
	FillOrigTestSum(src)
	CopyOrigSum(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSumUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Sum{}
	UnmarshalJSONOrigSum(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Sum{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSum(t *testing.T) {
	for name, src := range getEncodingTestValuesSum() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSum(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Sum{}
			UnmarshalJSONOrigSum(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSum(t *testing.T) {
	for name, src := range getEncodingTestValuesSum() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSum(src))
			gotSize := MarshalProtoOrigSum(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Sum{}
			require.NoError(t, UnmarshalProtoOrigSum(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSum() map[string]*otlpmetrics.Sum {
	return map[string]*otlpmetrics.Sum{
		"empty": {},
		"fill_test": func() *otlpmetrics.Sum {
			src := &otlpmetrics.Sum{}
			FillOrigTestSum(src)
			return src
		}(),
	}
}
