// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigSummaryDataPoint(t *testing.T) {
	src := &otlpmetrics.SummaryDataPoint{}
	dest := &otlpmetrics.SummaryDataPoint{}
	CopyOrigSummaryDataPoint(dest, src)
	assert.Equal(t, &otlpmetrics.SummaryDataPoint{}, dest)
	FillOrigTestSummaryDataPoint(src)
	CopyOrigSummaryDataPoint(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.SummaryDataPoint{}
	UnmarshalJSONOrigSummaryDataPoint(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.SummaryDataPoint{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigSummaryDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigSummaryDataPoint(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.SummaryDataPoint{}
			UnmarshalJSONOrigSummaryDataPoint(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigSummaryDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigSummaryDataPoint(src))
			gotSize := MarshalProtoOrigSummaryDataPoint(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.SummaryDataPoint{}
			require.NoError(t, UnmarshalProtoOrigSummaryDataPoint(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesSummaryDataPoint() map[string]*otlpmetrics.SummaryDataPoint {
	return map[string]*otlpmetrics.SummaryDataPoint{
		"empty": {},
		"fill_test": func() *otlpmetrics.SummaryDataPoint {
			src := &otlpmetrics.SummaryDataPoint{}
			FillOrigTestSummaryDataPoint(src)
			return src
		}(),
	}
}
