// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigSummaryDataPointSlice(dest, src []*otlpmetrics.SummaryDataPoint) []*otlpmetrics.SummaryDataPoint {
	var newDest []*otlpmetrics.SummaryDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.SummaryDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.SummaryDataPoint{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpmetrics.SummaryDataPoint{}
		}
	}
	for i := range src {
		CopyOrigSummaryDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSummaryDataPointSlice() []*otlpmetrics.SummaryDataPoint {
	orig := make([]*otlpmetrics.SummaryDataPoint, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpmetrics.SummaryDataPoint{}
		FillOrigTestSummaryDataPoint(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigSummaryDataPointSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSummaryDataPointSlice(iter *json.Iterator) []*otlpmetrics.SummaryDataPoint {
	var orig []*otlpmetrics.SummaryDataPoint
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpmetrics.SummaryDataPoint{})
		UnmarshalJSONOrigSummaryDataPoint(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
