// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigValueTypeSlice(dest, src []*otlpprofiles.ValueType) []*otlpprofiles.ValueType {
	var newDest []*otlpprofiles.ValueType
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.ValueType, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.ValueType{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.ValueType{}
		}
	}
	for i := range src {
		CopyOrigValueType(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestValueTypeSlice() []*otlpprofiles.ValueType {
	orig := make([]*otlpprofiles.ValueType, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpprofiles.ValueType{}
		FillOrigTestValueType(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigValueTypeSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigValueTypeSlice(iter *json.Iterator) []*otlpprofiles.ValueType {
	var orig []*otlpprofiles.ValueType
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpprofiles.ValueType{})
		UnmarshalJSONOrigValueType(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
