// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
)

func TestMetrics_MoveTo(t *testing.T) {
	ms := generateTestMetrics()
	dest := NewMetrics()
	ms.MoveTo(dest)
	assert.Equal(t, NewMetrics(), ms)
	assert.Equal(t, generateTestMetrics(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestMetrics(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newMetrics(&otlpcollectormetrics.ExportMetricsServiceRequest{}, &sharedState)) })
	assert.Panics(t, func() { newMetrics(&otlpcollectormetrics.ExportMetricsServiceRequest{}, &sharedState).MoveTo(dest) })
}

func TestMetrics_CopyTo(t *testing.T) {
	ms := NewMetrics()
	orig := NewMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newMetrics(&otlpcollectormetrics.ExportMetricsServiceRequest{}, &sharedState)) })
}

func TestMetrics_ResourceMetrics(t *testing.T) {
	ms := NewMetrics()
	assert.Equal(t, NewResourceMetricsSlice(), ms.ResourceMetrics())
	ms.getOrig().ResourceMetrics = internal.GenerateOrigTestResourceMetricsSlice()
	assert.Equal(t, generateTestResourceMetricsSlice(), ms.ResourceMetrics())
}

func generateTestMetrics() Metrics {
	return Metrics(internal.GenerateTestMetrics())
}
