// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestScopeMetrics_MoveTo(t *testing.T) {
	ms := generateTestScopeMetrics()
	dest := NewScopeMetrics()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeMetrics(), ms)
	assert.Equal(t, generateTestScopeMetrics(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestScopeMetrics(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newScopeMetrics(&otlpmetrics.ScopeMetrics{}, &sharedState)) })
	assert.Panics(t, func() { newScopeMetrics(&otlpmetrics.ScopeMetrics{}, &sharedState).MoveTo(dest) })
}

func TestScopeMetrics_CopyTo(t *testing.T) {
	ms := NewScopeMetrics()
	orig := NewScopeMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestScopeMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newScopeMetrics(&otlpmetrics.ScopeMetrics{}, &sharedState)) })
}

func TestScopeMetrics_Scope(t *testing.T) {
	ms := NewScopeMetrics()
	assert.Equal(t, pcommon.NewInstrumentationScope(), ms.Scope())
	internal.FillOrigTestInstrumentationScope(&ms.orig.Scope)
	assert.Equal(t, pcommon.InstrumentationScope(internal.GenerateTestInstrumentationScope()), ms.Scope())
}

func TestScopeMetrics_Metrics(t *testing.T) {
	ms := NewScopeMetrics()
	assert.Equal(t, NewMetricSlice(), ms.Metrics())
	ms.orig.Metrics = internal.GenerateOrigTestMetricSlice()
	assert.Equal(t, generateTestMetricSlice(), ms.Metrics())
}

func TestScopeMetrics_SchemaUrl(t *testing.T) {
	ms := NewScopeMetrics()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newScopeMetrics(&otlpmetrics.ScopeMetrics{}, &sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestScopeMetrics() ScopeMetrics {
	ms := NewScopeMetrics()
	internal.FillOrigTestScopeMetrics(ms.orig)
	return ms
}
