// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestResourceProfiles_MoveTo(t *testing.T) {
	ms := generateTestResourceProfiles()
	dest := NewResourceProfiles()
	ms.MoveTo(dest)
	assert.Equal(t, NewResourceProfiles(), ms)
	assert.Equal(t, generateTestResourceProfiles(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestResourceProfiles(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newResourceProfiles(internal.NewOrigResourceProfiles(), sharedState)) })
	assert.Panics(t, func() { newResourceProfiles(internal.NewOrigResourceProfiles(), sharedState).MoveTo(dest) })
}

func TestResourceProfiles_CopyTo(t *testing.T) {
	ms := NewResourceProfiles()
	orig := NewResourceProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestResourceProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newResourceProfiles(internal.NewOrigResourceProfiles(), sharedState)) })
}

func TestResourceProfiles_Resource(t *testing.T) {
	ms := NewResourceProfiles()
	assert.Equal(t, pcommon.NewResource(), ms.Resource())
	ms.orig.Resource = *internal.GenTestOrigResource()
	assert.Equal(t, pcommon.Resource(internal.NewResource(internal.GenTestOrigResource(), ms.state)), ms.Resource())
}

func TestResourceProfiles_ScopeProfiles(t *testing.T) {
	ms := NewResourceProfiles()
	assert.Equal(t, NewScopeProfilesSlice(), ms.ScopeProfiles())
	ms.orig.ScopeProfiles = internal.GenerateOrigTestScopeProfilesSlice()
	assert.Equal(t, generateTestScopeProfilesSlice(), ms.ScopeProfiles())
}

func TestResourceProfiles_SchemaUrl(t *testing.T) {
	ms := NewResourceProfiles()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newResourceProfiles(&otlpprofiles.ResourceProfiles{}, sharedState).SetSchemaUrl("test_schemaurl")
	})
}

func generateTestResourceProfiles() ResourceProfiles {
	ms := newResourceProfiles(internal.GenTestOrigResourceProfiles(), internal.NewState())
	return ms
}
