// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigMetric()
				CopyOrigMetric(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigMetric(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigMetricUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigMetric()
	UnmarshalJSONOrigMetric(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigMetric(), dest)
}

func TestMarshalAndUnmarshalJSONOrigMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigMetric(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigMetric()
				UnmarshalJSONOrigMetric(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigMetric(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigMetricFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesMetric() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigMetric()
			require.Error(t, UnmarshalProtoOrigMetric(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigMetricUnknown(t *testing.T) {
	dest := NewOrigMetric()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigMetric(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigMetric(), dest)
}

func TestMarshalAndUnmarshalProtoOrigMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigMetric(src))
				gotSize := MarshalProtoOrigMetric(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigMetric()
				require.NoError(t, UnmarshalProtoOrigMetric(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigMetric(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigMetric(src))
			gotSize := MarshalProtoOrigMetric(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Metric{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigMetric()
			require.NoError(t, UnmarshalProtoOrigMetric(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesMetric() map[string][]byte {
	return map[string][]byte{
		"invalid_field":               {0x02},
		"Name/wrong_wire_type":        {0xc},
		"Name/missing_value":          {0xa},
		"Description/wrong_wire_type": {0x14},
		"Description/missing_value":   {0x12},
		"Unit/wrong_wire_type":        {0x1c},
		"Unit/missing_value":          {0x1a},

		"Gauge/wrong_wire_type": {0x2c},
		"Gauge/missing_value":   {0x2a},

		"Sum/wrong_wire_type": {0x3c},
		"Sum/missing_value":   {0x3a},

		"Histogram/wrong_wire_type": {0x4c},
		"Histogram/missing_value":   {0x4a},

		"ExponentialHistogram/wrong_wire_type": {0x54},
		"ExponentialHistogram/missing_value":   {0x52},

		"Summary/wrong_wire_type":  {0x5c},
		"Summary/missing_value":    {0x5a},
		"Metadata/wrong_wire_type": {0x64},
		"Metadata/missing_value":   {0x62},
	}
}

func genTestEncodingValuesMetric() map[string]*otlpmetrics.Metric {
	return map[string]*otlpmetrics.Metric{
		"empty":                        NewOrigMetric(),
		"Name/test":                    {Name: "test_name"},
		"Description/test":             {Description: "test_description"},
		"Unit/test":                    {Unit: "test_unit"},
		"Gauge/default":                {Data: &otlpmetrics.Metric_Gauge{Gauge: &otlpmetrics.Gauge{}}},
		"Gauge/test":                   {Data: &otlpmetrics.Metric_Gauge{Gauge: GenTestOrigGauge()}},
		"Sum/default":                  {Data: &otlpmetrics.Metric_Sum{Sum: &otlpmetrics.Sum{}}},
		"Sum/test":                     {Data: &otlpmetrics.Metric_Sum{Sum: GenTestOrigSum()}},
		"Histogram/default":            {Data: &otlpmetrics.Metric_Histogram{Histogram: &otlpmetrics.Histogram{}}},
		"Histogram/test":               {Data: &otlpmetrics.Metric_Histogram{Histogram: GenTestOrigHistogram()}},
		"ExponentialHistogram/default": {Data: &otlpmetrics.Metric_ExponentialHistogram{ExponentialHistogram: &otlpmetrics.ExponentialHistogram{}}},
		"ExponentialHistogram/test":    {Data: &otlpmetrics.Metric_ExponentialHistogram{ExponentialHistogram: GenTestOrigExponentialHistogram()}},
		"Summary/default":              {Data: &otlpmetrics.Metric_Summary{Summary: &otlpmetrics.Summary{}}},
		"Summary/test":                 {Data: &otlpmetrics.Metric_Summary{Summary: GenTestOrigSummary()}},
		"Metadata/default_and_test":    {Metadata: []otlpcommon.KeyValue{{}, *GenTestOrigKeyValue()}},
	}
}
