// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
)

func TestCopyOrigScopeLogsSlice(t *testing.T) {
	src := []*otlplogs.ScopeLogs{}
	dest := []*otlplogs.ScopeLogs{}
	// Test CopyTo empty
	dest = CopyOrigScopeLogsSlice(dest, src)
	assert.Equal(t, []*otlplogs.ScopeLogs{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestScopeLogsSlice()
	dest = CopyOrigScopeLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeLogsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigScopeLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeLogsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigScopeLogsSlice(dest, []*otlplogs.ScopeLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigScopeLogsSlice(dest, src)
	assert.Equal(t, GenerateOrigTestScopeLogsSlice(), dest)
}
