// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// KeyValueAndUnit represents a custom 'dictionary native'
// style of encoding attributes which is more convenient
// for profiles than opentelemetry.proto.common.v1.KeyValue.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewKeyValueAndUnit function to create new instances.
// Important: zero-initialized instance is not valid for use.
type KeyValueAndUnit struct {
	orig  *otlpprofiles.KeyValueAndUnit
	state *internal.State
}

func newKeyValueAndUnit(orig *otlpprofiles.KeyValueAndUnit, state *internal.State) KeyValueAndUnit {
	return KeyValueAndUnit{orig: orig, state: state}
}

// NewKeyValueAndUnit creates a new empty KeyValueAndUnit.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewKeyValueAndUnit() KeyValueAndUnit {
	return newKeyValueAndUnit(internal.NewOrigKeyValueAndUnit(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms KeyValueAndUnit) MoveTo(dest KeyValueAndUnit) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	internal.DeleteOrigKeyValueAndUnit(dest.orig, false)
	*dest.orig, *ms.orig = *ms.orig, *dest.orig
}

// KeyStrindex returns the keystrindex associated with this KeyValueAndUnit.
func (ms KeyValueAndUnit) KeyStrindex() int32 {
	return ms.orig.KeyStrindex
}

// SetKeyStrindex replaces the keystrindex associated with this KeyValueAndUnit.
func (ms KeyValueAndUnit) SetKeyStrindex(v int32) {
	ms.state.AssertMutable()
	ms.orig.KeyStrindex = v
}

// Value returns the value associated with this KeyValueAndUnit.
func (ms KeyValueAndUnit) Value() pcommon.Value {
	return pcommon.Value(internal.NewValue(&ms.orig.Value, ms.state))
}

// UnitStrindex returns the unitstrindex associated with this KeyValueAndUnit.
func (ms KeyValueAndUnit) UnitStrindex() int32 {
	return ms.orig.UnitStrindex
}

// SetUnitStrindex replaces the unitstrindex associated with this KeyValueAndUnit.
func (ms KeyValueAndUnit) SetUnitStrindex(v int32) {
	ms.state.AssertMutable()
	ms.orig.UnitStrindex = v
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms KeyValueAndUnit) CopyTo(dest KeyValueAndUnit) {
	dest.state.AssertMutable()
	internal.CopyOrigKeyValueAndUnit(dest.orig, ms.orig)
}
