// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package proto // import "go.opentelemetry.io/collector/internal/cmd/pdatagen/internal/proto"

import (
	"go.opentelemetry.io/collector/internal/cmd/pdatagen/internal/template"
)

const enumMessageTemplate = `
// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

const (
	{{- range .Fields }}
	{{ $.Name }}_{{ .Name }} = {{ $.Name }}({{ .Value }})
	{{- end }}
)

{{ .Description }}
type {{ .Name }} int32

var {{ .Name }}_name = map[int32]string {
	{{- range .Fields }}
	{{ .Value }}: "{{ .Name }}",
	{{- end }}
}

var {{ .Name }}_value = map[string]int32 {
	{{- range .Fields }}
	"{{ .Name }}": {{ .Value }},
	{{- end }}
}

`

type Enum struct {
	Name        string
	Description string
	Fields      []*EnumField
}

type EnumField struct {
	Name  string
	Value int
}

func (ms *Enum) GenerateEnum() []byte {
	return []byte(template.Execute(template.Parse("enumMessageTemplate", []byte(enumMessageTemplate)), ms))
}

func (ms *Enum) templateFields(imports, testImports []string) map[string]any {
	return map[string]any{
		"fields":      ms.Fields,
		"messageName": ms.Name,
		"description": ms.Description,
		"imports":     imports,
		"testImports": testImports,
	}
}
