// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestLocation_MoveTo(t *testing.T) {
	ms := generateTestLocation()
	dest := NewLocation()
	ms.MoveTo(dest)
	assert.Equal(t, NewLocation(), ms)
	assert.Equal(t, generateTestLocation(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestLocation(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newLocation(internal.NewLocation(), sharedState)) })
	assert.Panics(t, func() { newLocation(internal.NewLocation(), sharedState).MoveTo(dest) })
}

func TestLocation_CopyTo(t *testing.T) {
	ms := NewLocation()
	orig := NewLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestLocation()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newLocation(internal.NewLocation(), sharedState)) })
}

func TestLocation_MappingIndex(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, int32(0), ms.MappingIndex())
	ms.SetMappingIndex(int32(13))
	assert.Equal(t, int32(13), ms.MappingIndex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newLocation(internal.NewLocation(), sharedState).SetMappingIndex(int32(13)) })
}

func TestLocation_Address(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, uint64(0), ms.Address())
	ms.SetAddress(uint64(13))
	assert.Equal(t, uint64(13), ms.Address())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newLocation(internal.NewLocation(), sharedState).SetAddress(uint64(13)) })
}

func TestLocation_Line(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, NewLineSlice(), ms.Line())
	ms.orig.Line = internal.GenTestLinePtrSlice()
	assert.Equal(t, generateTestLineSlice(), ms.Line())
}

func TestLocation_AttributeIndices(t *testing.T) {
	ms := NewLocation()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.AttributeIndices())
	ms.orig.AttributeIndices = internal.GenTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenTestInt32SliceWrapper()), ms.AttributeIndices())
}

func generateTestLocation() Location {
	return newLocation(internal.GenTestLocation(), internal.NewState())
}
