// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorprofiles "go.opentelemetry.io/proto/slim/otlp/collector/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportProfilesPartialSuccess()
				CopyExportProfilesPartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyExportProfilesPartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportProfilesPartialSuccessSlice(t *testing.T) {
	src := []ExportProfilesPartialSuccess{}
	dest := []ExportProfilesPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportProfilesPartialSuccessSlice(dest, src)
	assert.Equal(t, []ExportProfilesPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesPartialSuccessSlice()
	dest = CopyExportProfilesPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesPartialSuccessSlice(dest, []ExportProfilesPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessSlice(), dest)
}

func TestCopyExportProfilesPartialSuccessPtrSlice(t *testing.T) {
	src := []*ExportProfilesPartialSuccess{}
	dest := []*ExportProfilesPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportProfilesPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, []*ExportProfilesPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesPartialSuccessPtrSlice()
	dest = CopyExportProfilesPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesPartialSuccessPtrSlice(dest, []*ExportProfilesPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesPartialSuccessPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportProfilesPartialSuccess()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportProfilesPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportProfilesPartialSuccess()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportProfilesPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesPartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportProfilesPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportProfilesPartialSuccess()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesPartialSuccessUnknown(t *testing.T) {
	dest := NewExportProfilesPartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportProfilesPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportProfilesPartialSuccess()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportProfilesPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportProfilesPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorprofiles.ExportProfilesPartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportProfilesPartialSuccess()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportProfilesPartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                    {0x02},
		"RejectedProfiles/wrong_wire_type": {0xc},
		"RejectedProfiles/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":     {0x14},
		"ErrorMessage/missing_value":       {0x12},
	}
}

func genTestEncodingValuesExportProfilesPartialSuccess() map[string]*ExportProfilesPartialSuccess {
	return map[string]*ExportProfilesPartialSuccess{
		"empty":                 NewExportProfilesPartialSuccess(),
		"RejectedProfiles/test": {RejectedProfiles: int64(13)},
		"ErrorMessage/test":     {ErrorMessage: "test_errormessage"},
	}
}
