// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyProfile(t *testing.T) {
	for name, src := range genTestEncodingValuesProfile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewProfile()
				CopyProfile(dest, src)
				assert.Equal(t, src, dest)
				CopyProfile(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyProfileSlice(t *testing.T) {
	src := []Profile{}
	dest := []Profile{}
	// Test CopyTo empty
	dest = CopyProfileSlice(dest, src)
	assert.Equal(t, []Profile{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfileSlice()
	dest = CopyProfileSlice(dest, src)
	assert.Equal(t, GenTestProfileSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfileSlice(dest, src)
	assert.Equal(t, GenTestProfileSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfileSlice(dest, []Profile{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfileSlice(dest, src)
	assert.Equal(t, GenTestProfileSlice(), dest)
}

func TestCopyProfilePtrSlice(t *testing.T) {
	src := []*Profile{}
	dest := []*Profile{}
	// Test CopyTo empty
	dest = CopyProfilePtrSlice(dest, src)
	assert.Equal(t, []*Profile{}, dest)

	// Test CopyTo larger slice
	src = GenTestProfilePtrSlice()
	dest = CopyProfilePtrSlice(dest, src)
	assert.Equal(t, GenTestProfilePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyProfilePtrSlice(dest, src)
	assert.Equal(t, GenTestProfilePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyProfilePtrSlice(dest, []*Profile{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyProfilePtrSlice(dest, src)
	assert.Equal(t, GenTestProfilePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONProfileUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewProfile()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewProfile(), dest)
}

func TestMarshalAndUnmarshalJSONProfile(t *testing.T) {
	for name, src := range genTestEncodingValuesProfile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewProfile()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteProfile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoProfileFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesProfile() {
		t.Run(name, func(t *testing.T) {
			dest := NewProfile()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoProfileUnknown(t *testing.T) {
	dest := NewProfile()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewProfile(), dest)
}

func TestMarshalAndUnmarshalProtoProfile(t *testing.T) {
	for name, src := range genTestEncodingValuesProfile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewProfile()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteProfile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufProfile(t *testing.T) {
	for name, src := range genTestEncodingValuesProfile() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Profile{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewProfile()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesProfile() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"SampleType/wrong_wire_type":             {0xc},
		"SampleType/missing_value":               {0xa},
		"Samples/wrong_wire_type":                {0x14},
		"Samples/missing_value":                  {0x12},
		"TimeUnixNano/wrong_wire_type":           {0x1c},
		"TimeUnixNano/missing_value":             {0x19},
		"DurationNano/wrong_wire_type":           {0x24},
		"DurationNano/missing_value":             {0x20},
		"PeriodType/wrong_wire_type":             {0x2c},
		"PeriodType/missing_value":               {0x2a},
		"Period/wrong_wire_type":                 {0x34},
		"Period/missing_value":                   {0x30},
		"ProfileId/wrong_wire_type":              {0x3c},
		"ProfileId/missing_value":                {0x3a},
		"DroppedAttributesCount/wrong_wire_type": {0x44},
		"DroppedAttributesCount/missing_value":   {0x40},
		"OriginalPayloadFormat/wrong_wire_type":  {0x4c},
		"OriginalPayloadFormat/missing_value":    {0x4a},
		"OriginalPayload/wrong_wire_type":        {0x54},
		"OriginalPayload/missing_value":          {0x52},
		"AttributeIndices/wrong_wire_type":       {0x5c},
		"AttributeIndices/missing_value":         {0x5a},
	}
}

func genTestEncodingValuesProfile() map[string]*Profile {
	return map[string]*Profile{
		"empty":                       NewProfile(),
		"SampleType/test":             {SampleType: *GenTestValueType()},
		"Samples/test":                {Samples: []*Sample{{}, GenTestSample()}},
		"TimeUnixNano/test":           {TimeUnixNano: uint64(13)},
		"DurationNano/test":           {DurationNano: uint64(13)},
		"PeriodType/test":             {PeriodType: *GenTestValueType()},
		"Period/test":                 {Period: int64(13)},
		"ProfileId/test":              {ProfileId: *GenTestProfileID()},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
		"OriginalPayloadFormat/test":  {OriginalPayloadFormat: "test_originalpayloadformat"},
		"OriginalPayload/test":        {OriginalPayload: []byte{1, 2, 3}},
		"AttributeIndices/test":       {AttributeIndices: []int32{int32(0), int32(13)}},
	}
}
