// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ScopeLogs is a collection of logs from a LibraryInstrumentation.
type ScopeLogs struct {
	Scope      InstrumentationScope
	LogRecords []*LogRecord
	SchemaUrl  string
}

var (
	protoPoolScopeLogs = sync.Pool{
		New: func() any {
			return &ScopeLogs{}
		},
	}
)

func NewScopeLogs() *ScopeLogs {
	if !UseProtoPooling.IsEnabled() {
		return &ScopeLogs{}
	}
	return protoPoolScopeLogs.Get().(*ScopeLogs)
}

func DeleteScopeLogs(orig *ScopeLogs, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteInstrumentationScope(&orig.Scope, false)
	for i := range orig.LogRecords {
		DeleteLogRecord(orig.LogRecords[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolScopeLogs.Put(orig)
	}
}

func CopyScopeLogs(dest, src *ScopeLogs) *ScopeLogs {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewScopeLogs()
	}
	CopyInstrumentationScope(&dest.Scope, &src.Scope)

	dest.LogRecords = CopyLogRecordPtrSlice(dest.LogRecords, src.LogRecords)

	dest.SchemaUrl = src.SchemaUrl

	return dest
}

func CopyScopeLogsSlice(dest, src []ScopeLogs) []ScopeLogs {
	var newDest []ScopeLogs
	if cap(dest) < len(src) {
		newDest = make([]ScopeLogs, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeLogs(&dest[i], false)
		}
	}
	for i := range src {
		CopyScopeLogs(&newDest[i], &src[i])
	}
	return newDest
}

func CopyScopeLogsPtrSlice(dest, src []*ScopeLogs) []*ScopeLogs {
	var newDest []*ScopeLogs
	if cap(dest) < len(src) {
		newDest = make([]*ScopeLogs, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeLogs()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteScopeLogs(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewScopeLogs()
		}
	}
	for i := range src {
		CopyScopeLogs(newDest[i], src[i])
	}
	return newDest
}

func (orig *ScopeLogs) Reset() {
	*orig = ScopeLogs{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ScopeLogs) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	orig.Scope.MarshalJSON(dest)
	if len(orig.LogRecords) > 0 {
		dest.WriteObjectField("logRecords")
		dest.WriteArrayStart()
		orig.LogRecords[0].MarshalJSON(dest)
		for i := 1; i < len(orig.LogRecords); i++ {
			dest.WriteMore()
			orig.LogRecords[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ScopeLogs) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "scope":

			orig.Scope.UnmarshalJSON(iter)
		case "logRecords", "log_records":
			for iter.ReadArray() {
				orig.LogRecords = append(orig.LogRecords, NewLogRecord())
				orig.LogRecords[len(orig.LogRecords)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *ScopeLogs) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Scope.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.LogRecords {
		l = orig.LogRecords[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ScopeLogs) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Scope.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.LogRecords) - 1; i >= 0; i-- {
		l = orig.LogRecords[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *ScopeLogs) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Scope.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LogRecords", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.LogRecords = append(orig.LogRecords, NewLogRecord())
			err = orig.LogRecords[len(orig.LogRecords)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestScopeLogs() *ScopeLogs {
	orig := NewScopeLogs()
	orig.Scope = *GenTestInstrumentationScope()
	orig.LogRecords = []*LogRecord{{}, GenTestLogRecord()}
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

func GenTestScopeLogsPtrSlice() []*ScopeLogs {
	orig := make([]*ScopeLogs, 5)
	orig[0] = NewScopeLogs()
	orig[1] = GenTestScopeLogs()
	orig[2] = NewScopeLogs()
	orig[3] = GenTestScopeLogs()
	orig[4] = NewScopeLogs()
	return orig
}

func GenTestScopeLogsSlice() []ScopeLogs {
	orig := make([]ScopeLogs, 5)
	orig[1] = *GenTestScopeLogs()
	orig[3] = *GenTestScopeLogs()
	return orig
}
