// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Location describes function and line table debug information.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewLocation function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Location struct {
	orig  *internal.Location
	state *internal.State
}

func newLocation(orig *internal.Location, state *internal.State) Location {
	return Location{orig: orig, state: state}
}

// NewLocation creates a new empty Location.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewLocation() Location {
	return newLocation(internal.NewLocation(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Location) MoveTo(dest Location) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	internal.DeleteLocation(dest.orig, false)
	*dest.orig, *ms.orig = *ms.orig, *dest.orig
}

// MappingIndex returns the mappingindex associated with this Location.
func (ms Location) MappingIndex() int32 {
	return ms.orig.MappingIndex
}

// SetMappingIndex replaces the mappingindex associated with this Location.
func (ms Location) SetMappingIndex(v int32) {
	ms.state.AssertMutable()
	ms.orig.MappingIndex = v
}

// Address returns the address associated with this Location.
func (ms Location) Address() uint64 {
	return ms.orig.Address
}

// SetAddress replaces the address associated with this Location.
func (ms Location) SetAddress(v uint64) {
	ms.state.AssertMutable()
	ms.orig.Address = v
}

// Lines returns the Lines associated with this Location.
func (ms Location) Lines() LineSlice {
	return newLineSlice(&ms.orig.Lines, ms.state)
}

// AttributeIndices returns the AttributeIndices associated with this Location.
func (ms Location) AttributeIndices() pcommon.Int32Slice {
	return pcommon.Int32Slice(internal.NewInt32SliceWrapper(&ms.orig.AttributeIndices, ms.state))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Location) CopyTo(dest Location) {
	dest.state.AssertMutable()
	internal.CopyLocation(dest.orig, ms.orig)
}
