// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLink()
				CopyLink(dest, src)
				assert.Equal(t, src, dest)
				CopyLink(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLinkSlice(t *testing.T) {
	src := []Link{}
	dest := []Link{}
	// Test CopyTo empty
	dest = CopyLinkSlice(dest, src)
	assert.Equal(t, []Link{}, dest)

	// Test CopyTo larger slice
	src = GenTestLinkSlice()
	dest = CopyLinkSlice(dest, src)
	assert.Equal(t, GenTestLinkSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLinkSlice(dest, src)
	assert.Equal(t, GenTestLinkSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLinkSlice(dest, []Link{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLinkSlice(dest, src)
	assert.Equal(t, GenTestLinkSlice(), dest)
}

func TestCopyLinkPtrSlice(t *testing.T) {
	src := []*Link{}
	dest := []*Link{}
	// Test CopyTo empty
	dest = CopyLinkPtrSlice(dest, src)
	assert.Equal(t, []*Link{}, dest)

	// Test CopyTo larger slice
	src = GenTestLinkPtrSlice()
	dest = CopyLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestLinkPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestLinkPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLinkPtrSlice(dest, []*Link{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestLinkPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLinkUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLink()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLink(), dest)
}

func TestMarshalAndUnmarshalJSONLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLink()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLinkFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLink() {
		t.Run(name, func(t *testing.T) {
			dest := NewLink()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLinkUnknown(t *testing.T) {
	dest := NewLink()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLink(), dest)
}

func TestMarshalAndUnmarshalProtoLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLink()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLink(t *testing.T) {
	for name, src := range genTestEncodingValuesLink() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Link{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLink()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLink() map[string][]byte {
	return map[string][]byte{
		"invalid_field":           {0x02},
		"TraceId/wrong_wire_type": {0xc},
		"TraceId/missing_value":   {0xa},
		"SpanId/wrong_wire_type":  {0x14},
		"SpanId/missing_value":    {0x12},
	}
}

func genTestEncodingValuesLink() map[string]*Link {
	return map[string]*Link{
		"empty":        NewLink(),
		"TraceId/test": {TraceId: *GenTestTraceID()},
		"SpanId/test":  {SpanId: *GenTestSpanID()},
	}
}
