// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package testdata

import (
	"time"

	"go.opentelemetry.io/collector/pdata/pcommon"
	"go.opentelemetry.io/collector/pdata/plog"
)

var (
	logTimestamp = pcommon.NewTimestampFromTime(time.Date(2020, 2, 11, 20, 26, 13, 789, time.UTC))
)

func GenerateLogs(count int) plog.Logs {
	ld := plog.NewLogs()
	initResource(ld.ResourceLogs().AppendEmpty().Resource())
	logs := ld.ResourceLogs().At(0).ScopeLogs().AppendEmpty().LogRecords()
	logs.EnsureCapacity(count)
	for i := 0; i < count; i++ {
		switch i % 2 {
		case 0:
			fillLogOne(logs.AppendEmpty())
		case 1:
			fillLogTwo(logs.AppendEmpty())
		}
	}
	return ld
}

func fillLogOne(log plog.LogRecord) {
	log.SetTimestamp(logTimestamp)
	log.SetDroppedAttributesCount(1)
	log.SetSeverityNumber(plog.SeverityNumberInfo)
	log.SetSeverityText("Info")
	log.SetSpanID([8]byte{0x01, 0x02, 0x04, 0x08})
	log.SetTraceID([16]byte{0x08, 0x04, 0x02, 0x01})

	attrs := log.Attributes()
	attrs.PutString("app", "server")
	attrs.PutInt("instance_num", 1)

	log.Body().SetStringVal("This is a log message")
}

func fillLogTwo(log plog.LogRecord) {
	log.SetTimestamp(logTimestamp)
	log.SetDroppedAttributesCount(1)
	log.SetSeverityNumber(plog.SeverityNumberInfo)
	log.SetSeverityText("Info")

	attrs := log.Attributes()
	attrs.PutString("customer", "acme")
	attrs.PutString("env", "dev")

	log.Body().SetStringVal("something happened")
}
