// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/metrics/v1/metrics.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_pdata_internal_data "go.opentelemetry.io/collector/pdata/internal/data"
	v11 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AggregationTemporality defines how a metric aggregator reports aggregated
// values. It describes how those values relate to the time interval over
// which they are aggregated.
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	// DELTA is an AggregationTemporality for a metric aggregator which reports
	// changes since last report time. Successive metrics contain aggregation of
	// values from continuous and non-overlapping intervals.
	//
	// The values for a DELTA metric are based only on the time interval
	// associated with one measurement cycle. There is no dependency on
	// previous measurements like is the case for CUMULATIVE metrics.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// DELTA metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0+1 to
	//      t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	// CUMULATIVE is an AggregationTemporality for a metric aggregator which
	// reports changes since a fixed start time. This means that current values
	// of a CUMULATIVE metric depend on all previous measurements since the
	// start time. Because of this, the sender is required to retain this state
	// in some form. If this state is lost or invalidated, the CUMULATIVE metric
	// values MUST be reset and a new fixed start time following the last
	// reported measurement time sent MUST be used.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// CUMULATIVE metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+2 with a value of 5.
	//   9. The system experiences a fault and loses state.
	//   10. The system recovers and resumes receiving at time=t_1.
	//   11. A request is received, the system measures 1 request.
	//   12. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_1 to
	//      t_0+1 with a value of 1.
	//
	// Note: Even though, when reporting changes since last report time, using
	// CUMULATIVE is valid, it is not recommended. This may cause problems for
	// systems that do not use start_time to determine when the aggregation
	// value was reset (e.g. Prometheus).
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

var AggregationTemporality_name = map[int32]string{
	0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
	1: "AGGREGATION_TEMPORALITY_DELTA",
	2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
}

var AggregationTemporality_value = map[string]int32{
	"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
	"AGGREGATION_TEMPORALITY_DELTA":       1,
	"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
}

func (x AggregationTemporality) String() string {
	return proto.EnumName(AggregationTemporality_name, int32(x))
}

func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{0}
}

// DataPointFlags is defined as a protobuf 'uint32' type and is to be used as a
// bit-field representing 32 distinct boolean flags.  Each flag defined in this
// enum is a bit-mask.  To test the presence of a single flag in the flags of
// a data point, for example, use an expression like:
//
//	(point.flags & FLAG_NO_RECORDED_VALUE) == FLAG_NO_RECORDED_VALUE
type DataPointFlags int32

const (
	DataPointFlags_FLAG_NONE DataPointFlags = 0
	// This DataPoint is valid but has no recorded value.  This value
	// SHOULD be used to reflect explicitly missing data in a series, as
	// for an equivalent to the Prometheus "staleness marker".
	DataPointFlags_FLAG_NO_RECORDED_VALUE DataPointFlags = 1
)

var DataPointFlags_name = map[int32]string{
	0: "FLAG_NONE",
	1: "FLAG_NO_RECORDED_VALUE",
}

var DataPointFlags_value = map[string]int32{
	"FLAG_NONE":              0,
	"FLAG_NO_RECORDED_VALUE": 1,
}

func (x DataPointFlags) String() string {
	return proto.EnumName(DataPointFlags_name, int32(x))
}

func (DataPointFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{1}
}

// MetricsData represents the metrics data that can be stored in a persistent
// storage, OR can be embedded by other protocols that transfer OTLP metrics
// data but do not implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type MetricsData struct {
	// An array of ResourceMetrics.
	// For data coming from a single resource this array will typically contain
	// one element. Intermediary nodes that receive data from multiple origins
	// typically batch the data before forwarding further and in that case this
	// array will contain multiple elements.
	ResourceMetrics []*ResourceMetrics `protobuf:"bytes,1,rep,name=resource_metrics,json=resourceMetrics,proto3" json:"resource_metrics,omitempty"`
}

func (m *MetricsData) Reset()         { *m = MetricsData{} }
func (m *MetricsData) String() string { return proto.CompactTextString(m) }
func (*MetricsData) ProtoMessage()    {}
func (*MetricsData) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{0}
}
func (m *MetricsData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricsData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricsData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricsData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsData.Merge(m, src)
}
func (m *MetricsData) XXX_Size() int {
	return m.Size()
}
func (m *MetricsData) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsData.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsData proto.InternalMessageInfo

func (m *MetricsData) GetResourceMetrics() []*ResourceMetrics {
	if m != nil {
		return m.ResourceMetrics
	}
	return nil
}

// A collection of ScopeMetrics from a Resource.
type ResourceMetrics struct {
	// The resource for the metrics in this message.
	// If this field is not set then no resource info is known.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of metrics that originate from a resource.
	ScopeMetrics []*ScopeMetrics `protobuf:"bytes,2,rep,name=scope_metrics,json=scopeMetrics,proto3" json:"scope_metrics,omitempty"`
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "scope_metrics" field which have their own schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceMetrics) Reset()         { *m = ResourceMetrics{} }
func (m *ResourceMetrics) String() string { return proto.CompactTextString(m) }
func (*ResourceMetrics) ProtoMessage()    {}
func (*ResourceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{1}
}
func (m *ResourceMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetrics.Merge(m, src)
}
func (m *ResourceMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetrics proto.InternalMessageInfo

func (m *ResourceMetrics) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceMetrics) GetScopeMetrics() []*ScopeMetrics {
	if m != nil {
		return m.ScopeMetrics
	}
	return nil
}

func (m *ResourceMetrics) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Metrics produced by an Scope.
type ScopeMetrics struct {
	// The instrumentation scope information for the metrics in this message.
	// Semantically when InstrumentationScope isn't set, it is equivalent with
	// an empty instrumentation scope name (unknown).
	Scope v11.InstrumentationScope `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope"`
	// A list of metrics that originate from an instrumentation library.
	Metrics []*Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// This schema_url applies to all metrics in the "metrics" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ScopeMetrics) Reset()         { *m = ScopeMetrics{} }
func (m *ScopeMetrics) String() string { return proto.CompactTextString(m) }
func (*ScopeMetrics) ProtoMessage()    {}
func (*ScopeMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{2}
}
func (m *ScopeMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScopeMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScopeMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScopeMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScopeMetrics.Merge(m, src)
}
func (m *ScopeMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ScopeMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ScopeMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ScopeMetrics proto.InternalMessageInfo

func (m *ScopeMetrics) GetScope() v11.InstrumentationScope {
	if m != nil {
		return m.Scope
	}
	return v11.InstrumentationScope{}
}

func (m *ScopeMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ScopeMetrics) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// Defines a Metric which has one or more timeseries.  The following is a
// brief summary of the Metric data model.  For more details, see:
//
//	https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md
//
// The data model and relation between entities is shown in the
// diagram below. Here, "DataPoint" is the term used to refer to any
// one of the specific data point value types, and "points" is the term used
// to refer to any one of the lists of points contained in the Metric.
//
//   - Metric is composed of a metadata and data.
//
//   - Metadata part contains a name, description, unit.
//
//   - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
//
//   - DataPoint contains timestamps, attributes, and one of the possible value type
//     fields.
//
//     Metric
//     +------------+
//     |name        |
//     |description |
//     |unit        |     +------------------------------------+
//     |data        |---> |Gauge, Sum, Histogram, Summary, ... |
//     +------------+     +------------------------------------+
//
//     Data [One of Gauge, Sum, Histogram, Summary, ...]
//     +-----------+
//     |...        |  // Metadata about the Data.
//     |points     |--+
//     +-----------+  |
//     |      +---------------------------+
//     |      |DataPoint 1                |
//     v      |+------+------+   +------+ |
//     +-----+   ||label |label |...|label | |
//     |  1  |-->||value1|value2|...|valueN| |
//     +-----+   |+------+------+   +------+ |
//     |  .  |   |+-----+                    |
//     |  .  |   ||value|                    |
//     |  .  |   |+-----+                    |
//     |  .  |   +---------------------------+
//     |  .  |                   .
//     |  .  |                   .
//     |  .  |                   .
//     |  .  |   +---------------------------+
//     |  .  |   |DataPoint M                |
//     +-----+   |+------+------+   +------+ |
//     |  M  |-->||label |label |...|label | |
//     +-----+   ||value1|value2|...|valueN| |
//     |+------+------+   +------+ |
//     |+-----+                    |
//     ||value|                    |
//     |+-----+                    |
//     +---------------------------+
//
// Each distinct type of DataPoint represents the output of a specific
// aggregation function, the result of applying the DataPoint's
// associated function of to one or more measurements.
//
// All DataPoint types have three common fields:
//   - Attributes includes key-value pairs associated with the data point
//   - TimeUnixNano is required, set to the end time of the aggregation
//   - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
//     having an AggregationTemporality field, as discussed below.
//
// Both TimeUnixNano and StartTimeUnixNano values are expressed as
// UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
//
// # TimeUnixNano
//
// This field is required, having consistent interpretation across
// DataPoint types.  TimeUnixNano is the moment corresponding to when
// the data point's aggregate value was captured.
//
// Data points with the 0 value for TimeUnixNano SHOULD be rejected
// by consumers.
//
// # StartTimeUnixNano
//
// StartTimeUnixNano in general allows detecting when a sequence of
// observations is unbroken.  This field indicates to consumers the
// start time for points with cumulative and delta
// AggregationTemporality, and it should be included whenever possible
// to support correct rate calculation.  Although it may be omitted
// when the start time is truly unknown, setting StartTimeUnixNano is
// strongly encouraged.
type Metric struct {
	// name of the metric, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// Data determines the aggregation type (if any) of the metric, what is the
	// reported value type for the data points, as well as the relatationship to
	// the time interval over which they are reported.
	//
	// Types that are valid to be assigned to Data:
	//	*Metric_Gauge
	//	*Metric_Sum
	//	*Metric_Histogram
	//	*Metric_ExponentialHistogram
	//	*Metric_Summary
	Data isMetric_Data `protobuf_oneof:"data"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{3}
}
func (m *Metric) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return m.Size()
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

type isMetric_Data interface {
	isMetric_Data()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Metric_Gauge struct {
	Gauge *Gauge `protobuf:"bytes,5,opt,name=gauge,proto3,oneof" json:"gauge,omitempty"`
}
type Metric_Sum struct {
	Sum *Sum `protobuf:"bytes,7,opt,name=sum,proto3,oneof" json:"sum,omitempty"`
}
type Metric_Histogram struct {
	Histogram *Histogram `protobuf:"bytes,9,opt,name=histogram,proto3,oneof" json:"histogram,omitempty"`
}
type Metric_ExponentialHistogram struct {
	ExponentialHistogram *ExponentialHistogram `protobuf:"bytes,10,opt,name=exponential_histogram,json=exponentialHistogram,proto3,oneof" json:"exponential_histogram,omitempty"`
}
type Metric_Summary struct {
	Summary *Summary `protobuf:"bytes,11,opt,name=summary,proto3,oneof" json:"summary,omitempty"`
}

func (*Metric_Gauge) isMetric_Data()                {}
func (*Metric_Sum) isMetric_Data()                  {}
func (*Metric_Histogram) isMetric_Data()            {}
func (*Metric_ExponentialHistogram) isMetric_Data() {}
func (*Metric_Summary) isMetric_Data()              {}

func (m *Metric) GetData() isMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Metric) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Metric) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *Metric) GetGauge() *Gauge {
	if x, ok := m.GetData().(*Metric_Gauge); ok {
		return x.Gauge
	}
	return nil
}

func (m *Metric) GetSum() *Sum {
	if x, ok := m.GetData().(*Metric_Sum); ok {
		return x.Sum
	}
	return nil
}

func (m *Metric) GetHistogram() *Histogram {
	if x, ok := m.GetData().(*Metric_Histogram); ok {
		return x.Histogram
	}
	return nil
}

func (m *Metric) GetExponentialHistogram() *ExponentialHistogram {
	if x, ok := m.GetData().(*Metric_ExponentialHistogram); ok {
		return x.ExponentialHistogram
	}
	return nil
}

func (m *Metric) GetSummary() *Summary {
	if x, ok := m.GetData().(*Metric_Summary); ok {
		return x.Summary
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Metric) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Metric_Gauge)(nil),
		(*Metric_Sum)(nil),
		(*Metric_Histogram)(nil),
		(*Metric_ExponentialHistogram)(nil),
		(*Metric_Summary)(nil),
	}
}

// Gauge represents the type of a scalar metric that always exports the
// "current value" for every data point. It should be used for an "unknown"
// aggregation.
//
// A Gauge does not support different aggregation temporalities. Given the
// aggregation is unknown, points cannot be combined using the same
// aggregation, regardless of aggregation temporalities. Therefore,
// AggregationTemporality is not included. Consequently, this also means
// "StartTimeUnixNano" is ignored for all data points.
type Gauge struct {
	DataPoints []*NumberDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (m *Gauge) Reset()         { *m = Gauge{} }
func (m *Gauge) String() string { return proto.CompactTextString(m) }
func (*Gauge) ProtoMessage()    {}
func (*Gauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{4}
}
func (m *Gauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Gauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Gauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Gauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gauge.Merge(m, src)
}
func (m *Gauge) XXX_Size() int {
	return m.Size()
}
func (m *Gauge) XXX_DiscardUnknown() {
	xxx_messageInfo_Gauge.DiscardUnknown(m)
}

var xxx_messageInfo_Gauge proto.InternalMessageInfo

func (m *Gauge) GetDataPoints() []*NumberDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

// Sum represents the type of a scalar metric that is calculated as a sum of all
// reported measurements over a time interval.
type Sum struct {
	DataPoints []*NumberDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
	// If "true" means that the sum is monotonic.
	IsMonotonic bool `protobuf:"varint,3,opt,name=is_monotonic,json=isMonotonic,proto3" json:"is_monotonic,omitempty"`
}

func (m *Sum) Reset()         { *m = Sum{} }
func (m *Sum) String() string { return proto.CompactTextString(m) }
func (*Sum) ProtoMessage()    {}
func (*Sum) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{5}
}
func (m *Sum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sum.Merge(m, src)
}
func (m *Sum) XXX_Size() int {
	return m.Size()
}
func (m *Sum) XXX_DiscardUnknown() {
	xxx_messageInfo_Sum.DiscardUnknown(m)
}

var xxx_messageInfo_Sum proto.InternalMessageInfo

func (m *Sum) GetDataPoints() []*NumberDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *Sum) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

func (m *Sum) GetIsMonotonic() bool {
	if m != nil {
		return m.IsMonotonic
	}
	return false
}

// Histogram represents the type of a metric that is calculated by aggregating
// as a Histogram of all reported measurements over a time interval.
type Histogram struct {
	DataPoints []*HistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *Histogram) Reset()         { *m = Histogram{} }
func (m *Histogram) String() string { return proto.CompactTextString(m) }
func (*Histogram) ProtoMessage()    {}
func (*Histogram) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{6}
}
func (m *Histogram) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Histogram) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Histogram.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Histogram) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Histogram.Merge(m, src)
}
func (m *Histogram) XXX_Size() int {
	return m.Size()
}
func (m *Histogram) XXX_DiscardUnknown() {
	xxx_messageInfo_Histogram.DiscardUnknown(m)
}

var xxx_messageInfo_Histogram proto.InternalMessageInfo

func (m *Histogram) GetDataPoints() []*HistogramDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *Histogram) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// ExponentialHistogram represents the type of a metric that is calculated by aggregating
// as a ExponentialHistogram of all reported double measurements over a time interval.
type ExponentialHistogram struct {
	DataPoints []*ExponentialHistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *ExponentialHistogram) Reset()         { *m = ExponentialHistogram{} }
func (m *ExponentialHistogram) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogram) ProtoMessage()    {}
func (*ExponentialHistogram) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{7}
}
func (m *ExponentialHistogram) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogram) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogram.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogram) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogram.Merge(m, src)
}
func (m *ExponentialHistogram) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogram) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogram.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogram proto.InternalMessageInfo

func (m *ExponentialHistogram) GetDataPoints() []*ExponentialHistogramDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *ExponentialHistogram) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Summary metric data are used to convey quantile summaries,
// a Prometheus (see: https://prometheus.io/docs/concepts/metric_types/#summary)
// and OpenMetrics (see: https://github.com/OpenObservability/OpenMetrics/blob/4dbf6075567ab43296eed941037c12951faafb92/protos/prometheus.proto#L45)
// data type. These data points cannot always be merged in a meaningful way.
// While they can be useful in some applications, histogram data points are
// recommended for new applications.
type Summary struct {
	DataPoints []*SummaryDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (m *Summary) Reset()         { *m = Summary{} }
func (m *Summary) String() string { return proto.CompactTextString(m) }
func (*Summary) ProtoMessage()    {}
func (*Summary) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{8}
}
func (m *Summary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Summary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Summary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Summary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Summary.Merge(m, src)
}
func (m *Summary) XXX_Size() int {
	return m.Size()
}
func (m *Summary) XXX_DiscardUnknown() {
	xxx_messageInfo_Summary.DiscardUnknown(m)
}

var xxx_messageInfo_Summary proto.InternalMessageInfo

func (m *Summary) GetDataPoints() []*SummaryDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

// NumberDataPoint is a single data point in a timeseries that describes the
// time-varying scalar value of a metric.
type NumberDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []v11.KeyValue `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The value itself.  A point is considered invalid when one of the recognized
	// value fields is not present inside this oneof.
	//
	// Types that are valid to be assigned to Value:
	//	*NumberDataPoint_AsDouble
	//	*NumberDataPoint_AsInt
	Value isNumberDataPoint_Value `protobuf_oneof:"value"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,5,rep,name=exemplars,proto3" json:"exemplars"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,8,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (m *NumberDataPoint) Reset()         { *m = NumberDataPoint{} }
func (m *NumberDataPoint) String() string { return proto.CompactTextString(m) }
func (*NumberDataPoint) ProtoMessage()    {}
func (*NumberDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{9}
}
func (m *NumberDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NumberDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NumberDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NumberDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NumberDataPoint.Merge(m, src)
}
func (m *NumberDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *NumberDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_NumberDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_NumberDataPoint proto.InternalMessageInfo

type isNumberDataPoint_Value interface {
	isNumberDataPoint_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type NumberDataPoint_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,4,opt,name=as_double,json=asDouble,proto3,oneof" json:"as_double,omitempty"`
}
type NumberDataPoint_AsInt struct {
	AsInt int64 `protobuf:"fixed64,6,opt,name=as_int,json=asInt,proto3,oneof" json:"as_int,omitempty"`
}

func (*NumberDataPoint_AsDouble) isNumberDataPoint_Value() {}
func (*NumberDataPoint_AsInt) isNumberDataPoint_Value()    {}

func (m *NumberDataPoint) GetValue() isNumberDataPoint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *NumberDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *NumberDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *NumberDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *NumberDataPoint) GetAsDouble() float64 {
	if x, ok := m.GetValue().(*NumberDataPoint_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (m *NumberDataPoint) GetAsInt() int64 {
	if x, ok := m.GetValue().(*NumberDataPoint_AsInt); ok {
		return x.AsInt
	}
	return 0
}

func (m *NumberDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

func (m *NumberDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NumberDataPoint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NumberDataPoint_AsDouble)(nil),
		(*NumberDataPoint_AsInt)(nil),
	}
}

// HistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Histogram. A Histogram contains summary statistics
// for a population of values, it may optionally contain the distribution of
// those values across a set of buckets.
//
// If the histogram contains the distribution of values, then both
// "explicit_bounds" and "bucket counts" fields must be defined.
// If the histogram does not contain the distribution of values, then both
// "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
// "sum" are known.
type HistogramDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []v11.KeyValue `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This
	// value must be equal to the sum of the "count" fields in buckets if a
	// histogram is provided.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
	//
	// Types that are valid to be assigned to Sum_:
	//	*HistogramDataPoint_Sum
	Sum_ isHistogramDataPoint_Sum_ `protobuf_oneof:"sum_"`
	// bucket_counts is an optional field contains the count values of histogram
	// for each bucket.
	//
	// The sum of the bucket_counts must equal the value in the count field.
	//
	// The number of elements in bucket_counts array must be by one greater than
	// the number of elements in explicit_bounds array.
	BucketCounts []uint64 `protobuf:"fixed64,6,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	//
	// The boundaries for bucket at index i are:
	//
	// (-infinity, explicit_bounds[i]] for i == 0
	// (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
	// (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
	//
	// The values in the explicit_bounds array must be strictly increasing.
	//
	// Histogram buckets are inclusive of their upper boundary, except the last
	// bucket where the boundary is at infinity. This format is intentionally
	// compatible with the OpenMetrics histogram definition.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
	// min is the minimum value over (start_time, end_time].
	//
	// Types that are valid to be assigned to Min_:
	//	*HistogramDataPoint_Min
	Min_ isHistogramDataPoint_Min_ `protobuf_oneof:"min_"`
	// max is the maximum value over (start_time, end_time].
	//
	// Types that are valid to be assigned to Max_:
	//	*HistogramDataPoint_Max
	Max_ isHistogramDataPoint_Max_ `protobuf_oneof:"max_"`
}

func (m *HistogramDataPoint) Reset()         { *m = HistogramDataPoint{} }
func (m *HistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint) ProtoMessage()    {}
func (*HistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{10}
}
func (m *HistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistogramDataPoint.Merge(m, src)
}
func (m *HistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *HistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_HistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_HistogramDataPoint proto.InternalMessageInfo

type isHistogramDataPoint_Sum_ interface {
	isHistogramDataPoint_Sum_()
	MarshalTo([]byte) (int, error)
	Size() int
}
type isHistogramDataPoint_Min_ interface {
	isHistogramDataPoint_Min_()
	MarshalTo([]byte) (int, error)
	Size() int
}
type isHistogramDataPoint_Max_ interface {
	isHistogramDataPoint_Max_()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HistogramDataPoint_Sum struct {
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3,oneof" json:"sum,omitempty"`
}
type HistogramDataPoint_Min struct {
	Min float64 `protobuf:"fixed64,11,opt,name=min,proto3,oneof" json:"min,omitempty"`
}
type HistogramDataPoint_Max struct {
	Max float64 `protobuf:"fixed64,12,opt,name=max,proto3,oneof" json:"max,omitempty"`
}

func (*HistogramDataPoint_Sum) isHistogramDataPoint_Sum_() {}
func (*HistogramDataPoint_Min) isHistogramDataPoint_Min_() {}
func (*HistogramDataPoint_Max) isHistogramDataPoint_Max_() {}

func (m *HistogramDataPoint) GetSum_() isHistogramDataPoint_Sum_ {
	if m != nil {
		return m.Sum_
	}
	return nil
}
func (m *HistogramDataPoint) GetMin_() isHistogramDataPoint_Min_ {
	if m != nil {
		return m.Min_
	}
	return nil
}
func (m *HistogramDataPoint) GetMax_() isHistogramDataPoint_Max_ {
	if m != nil {
		return m.Max_
	}
	return nil
}

func (m *HistogramDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *HistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint) GetSum() float64 {
	if x, ok := m.GetSum_().(*HistogramDataPoint_Sum); ok {
		return x.Sum
	}
	return 0
}

func (m *HistogramDataPoint) GetBucketCounts() []uint64 {
	if m != nil {
		return m.BucketCounts
	}
	return nil
}

func (m *HistogramDataPoint) GetExplicitBounds() []float64 {
	if m != nil {
		return m.ExplicitBounds
	}
	return nil
}

func (m *HistogramDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

func (m *HistogramDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *HistogramDataPoint) GetMin() float64 {
	if x, ok := m.GetMin_().(*HistogramDataPoint_Min); ok {
		return x.Min
	}
	return 0
}

func (m *HistogramDataPoint) GetMax() float64 {
	if x, ok := m.GetMax_().(*HistogramDataPoint_Max); ok {
		return x.Max
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HistogramDataPoint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HistogramDataPoint_Sum)(nil),
		(*HistogramDataPoint_Min)(nil),
		(*HistogramDataPoint_Max)(nil),
	}
}

// ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
type ExponentialHistogramDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []v11.KeyValue `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be
	// non-negative. This value must be equal to the sum of the "bucket_counts"
	// values in the positive and negative Buckets plus the "zero_count" field.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
	//
	// Types that are valid to be assigned to Sum_:
	//	*ExponentialHistogramDataPoint_Sum
	Sum_ isExponentialHistogramDataPoint_Sum_ `protobuf_oneof:"sum_"`
	// scale describes the resolution of the histogram.  Boundaries are
	// located at powers of the base, where:
	//
	//   base = (2^(2^-scale))
	//
	// The histogram bucket identified by `index`, a signed integer,
	// contains values that are greater than or equal to (base^index) and
	// less than (base^(index+1)).
	//
	// The positive and negative ranges of the histogram are expressed
	// separately.  Negative values are mapped by their absolute value
	// into the negative range using the same scale as the positive range.
	//
	// scale is not restricted by the protocol, as the permissible
	// values depend on the range of the data.
	Scale int32 `protobuf:"zigzag32,6,opt,name=scale,proto3" json:"scale,omitempty"`
	// zero_count is the count of values that are either exactly zero or
	// within the region considered zero by the instrumentation at the
	// tolerated degree of precision.  This bucket stores values that
	// cannot be expressed using the standard exponential formula as
	// well as values that have been rounded to zero.
	//
	// Implementations MAY consider the zero bucket to have probability
	// mass equal to (zero_count / count).
	ZeroCount uint64 `protobuf:"fixed64,7,opt,name=zero_count,json=zeroCount,proto3" json:"zero_count,omitempty"`
	// positive carries the positive range of exponential bucket counts.
	Positive ExponentialHistogramDataPoint_Buckets `protobuf:"bytes,8,opt,name=positive,proto3" json:"positive"`
	// negative carries the negative range of exponential bucket counts.
	Negative ExponentialHistogramDataPoint_Buckets `protobuf:"bytes,9,opt,name=negative,proto3" json:"negative"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,11,rep,name=exemplars,proto3" json:"exemplars"`
	// min is the minimum value over (start_time, end_time].
	//
	// Types that are valid to be assigned to Min_:
	//	*ExponentialHistogramDataPoint_Min
	Min_ isExponentialHistogramDataPoint_Min_ `protobuf_oneof:"min_"`
	// max is the maximum value over (start_time, end_time].
	//
	// Types that are valid to be assigned to Max_:
	//	*ExponentialHistogramDataPoint_Max
	Max_ isExponentialHistogramDataPoint_Max_ `protobuf_oneof:"max_"`
}

func (m *ExponentialHistogramDataPoint) Reset()         { *m = ExponentialHistogramDataPoint{} }
func (m *ExponentialHistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogramDataPoint) ProtoMessage()    {}
func (*ExponentialHistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{11}
}
func (m *ExponentialHistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogramDataPoint.Merge(m, src)
}
func (m *ExponentialHistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogramDataPoint proto.InternalMessageInfo

type isExponentialHistogramDataPoint_Sum_ interface {
	isExponentialHistogramDataPoint_Sum_()
	MarshalTo([]byte) (int, error)
	Size() int
}
type isExponentialHistogramDataPoint_Min_ interface {
	isExponentialHistogramDataPoint_Min_()
	MarshalTo([]byte) (int, error)
	Size() int
}
type isExponentialHistogramDataPoint_Max_ interface {
	isExponentialHistogramDataPoint_Max_()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ExponentialHistogramDataPoint_Sum struct {
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3,oneof" json:"sum,omitempty"`
}
type ExponentialHistogramDataPoint_Min struct {
	Min float64 `protobuf:"fixed64,12,opt,name=min,proto3,oneof" json:"min,omitempty"`
}
type ExponentialHistogramDataPoint_Max struct {
	Max float64 `protobuf:"fixed64,13,opt,name=max,proto3,oneof" json:"max,omitempty"`
}

func (*ExponentialHistogramDataPoint_Sum) isExponentialHistogramDataPoint_Sum_() {}
func (*ExponentialHistogramDataPoint_Min) isExponentialHistogramDataPoint_Min_() {}
func (*ExponentialHistogramDataPoint_Max) isExponentialHistogramDataPoint_Max_() {}

func (m *ExponentialHistogramDataPoint) GetSum_() isExponentialHistogramDataPoint_Sum_ {
	if m != nil {
		return m.Sum_
	}
	return nil
}
func (m *ExponentialHistogramDataPoint) GetMin_() isExponentialHistogramDataPoint_Min_ {
	if m != nil {
		return m.Min_
	}
	return nil
}
func (m *ExponentialHistogramDataPoint) GetMax_() isExponentialHistogramDataPoint_Max_ {
	if m != nil {
		return m.Max_
	}
	return nil
}

func (m *ExponentialHistogramDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ExponentialHistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetSum() float64 {
	if x, ok := m.GetSum_().(*ExponentialHistogramDataPoint_Sum); ok {
		return x.Sum
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetScale() int32 {
	if m != nil {
		return m.Scale
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetZeroCount() uint64 {
	if m != nil {
		return m.ZeroCount
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetPositive() ExponentialHistogramDataPoint_Buckets {
	if m != nil {
		return m.Positive
	}
	return ExponentialHistogramDataPoint_Buckets{}
}

func (m *ExponentialHistogramDataPoint) GetNegative() ExponentialHistogramDataPoint_Buckets {
	if m != nil {
		return m.Negative
	}
	return ExponentialHistogramDataPoint_Buckets{}
}

func (m *ExponentialHistogramDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

func (m *ExponentialHistogramDataPoint) GetMin() float64 {
	if x, ok := m.GetMin_().(*ExponentialHistogramDataPoint_Min); ok {
		return x.Min
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetMax() float64 {
	if x, ok := m.GetMax_().(*ExponentialHistogramDataPoint_Max); ok {
		return x.Max
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExponentialHistogramDataPoint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExponentialHistogramDataPoint_Sum)(nil),
		(*ExponentialHistogramDataPoint_Min)(nil),
		(*ExponentialHistogramDataPoint_Max)(nil),
	}
}

// Buckets are a set of bucket counts, encoded in a contiguous array
// of counts.
type ExponentialHistogramDataPoint_Buckets struct {
	// Offset is the bucket index of the first entry in the bucket_counts array.
	//
	// Note: This uses a varint encoding as a simple form of compression.
	Offset int32 `protobuf:"zigzag32,1,opt,name=offset,proto3" json:"offset,omitempty"`
	// Count is an array of counts, where count[i] carries the count
	// of the bucket at index (offset+i).  count[i] is the count of
	// values greater than or equal to base^(offset+i) and less than
	// base^(offset+i+1).
	//
	// Note: By contrast, the explicit HistogramDataPoint uses
	// fixed64.  This field is expected to have many buckets,
	// especially zeros, so uint64 has been selected to ensure
	// varint encoding.
	BucketCounts []uint64 `protobuf:"varint,2,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
}

func (m *ExponentialHistogramDataPoint_Buckets) Reset()         { *m = ExponentialHistogramDataPoint_Buckets{} }
func (m *ExponentialHistogramDataPoint_Buckets) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogramDataPoint_Buckets) ProtoMessage()    {}
func (*ExponentialHistogramDataPoint_Buckets) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{11, 0}
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.Merge(m, src)
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogramDataPoint_Buckets proto.InternalMessageInfo

func (m *ExponentialHistogramDataPoint_Buckets) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ExponentialHistogramDataPoint_Buckets) GetBucketCounts() []uint64 {
	if m != nil {
		return m.BucketCounts
	}
	return nil
}

// SummaryDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Summary metric.
type SummaryDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	// Attribute keys MUST be unique (it is not allowed to have more than one
	// attribute with the same key).
	Attributes []v11.KeyValue `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#summary
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// (Optional) list of values at different quantiles of the distribution calculated
	// from the current snapshot. The quantiles must be strictly increasing.
	QuantileValues []*SummaryDataPoint_ValueAtQuantile `protobuf:"bytes,6,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,8,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (m *SummaryDataPoint) Reset()         { *m = SummaryDataPoint{} }
func (m *SummaryDataPoint) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint) ProtoMessage()    {}
func (*SummaryDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{12}
}
func (m *SummaryDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint.Merge(m, src)
}
func (m *SummaryDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint proto.InternalMessageInfo

func (m *SummaryDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *SummaryDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SummaryDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *SummaryDataPoint) GetQuantileValues() []*SummaryDataPoint_ValueAtQuantile {
	if m != nil {
		return m.QuantileValues
	}
	return nil
}

func (m *SummaryDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// Represents the value at a given quantile of a distribution.
//
// To record Min and Max values following conventions are used:
// - The 1.0 quantile is equivalent to the maximum value observed.
// - The 0.0 quantile is equivalent to the minimum value observed.
//
// See the following issue for more context:
// https://github.com/open-telemetry/opentelemetry-proto/issues/125
type SummaryDataPoint_ValueAtQuantile struct {
	// The quantile of a distribution. Must be in the interval
	// [0.0, 1.0].
	Quantile float64 `protobuf:"fixed64,1,opt,name=quantile,proto3" json:"quantile,omitempty"`
	// The value at the given quantile of a distribution.
	//
	// Quantile values must NOT be negative.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *SummaryDataPoint_ValueAtQuantile) Reset()         { *m = SummaryDataPoint_ValueAtQuantile{} }
func (m *SummaryDataPoint_ValueAtQuantile) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint_ValueAtQuantile) ProtoMessage()    {}
func (*SummaryDataPoint_ValueAtQuantile) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{12, 0}
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.Merge(m, src)
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint_ValueAtQuantile proto.InternalMessageInfo

func (m *SummaryDataPoint_ValueAtQuantile) GetQuantile() float64 {
	if m != nil {
		return m.Quantile
	}
	return 0
}

func (m *SummaryDataPoint_ValueAtQuantile) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// A representation of an exemplar, which is a sample input measurement.
// Exemplars also hold information about the environment when the measurement
// was recorded, for example the span and trace ID of the active span when the
// exemplar was recorded.
type Exemplar struct {
	// The set of key/value pairs that were filtered out by the aggregator, but
	// recorded alongside the original measurement. Only key/value pairs that were
	// filtered out by the aggregator should be included
	FilteredAttributes []v11.KeyValue `protobuf:"bytes,7,rep,name=filtered_attributes,json=filteredAttributes,proto3" json:"filtered_attributes"`
	// time_unix_nano is the exact time when this exemplar was recorded
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The value of the measurement that was recorded. An exemplar is
	// considered invalid when one of the recognized value fields is not present
	// inside this oneof.
	//
	// Types that are valid to be assigned to Value:
	//	*Exemplar_AsDouble
	//	*Exemplar_AsInt
	Value isExemplar_Value `protobuf_oneof:"value"`
	// (Optional) Span ID of the exemplar trace.
	// span_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	SpanId go_opentelemetry_io_collector_pdata_internal_data.SpanID `protobuf:"bytes,4,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.SpanID" json:"span_id"`
	// (Optional) Trace ID of the exemplar trace.
	// trace_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	TraceId go_opentelemetry_io_collector_pdata_internal_data.TraceID `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/pdata/internal/data.TraceID" json:"trace_id"`
}

func (m *Exemplar) Reset()         { *m = Exemplar{} }
func (m *Exemplar) String() string { return proto.CompactTextString(m) }
func (*Exemplar) ProtoMessage()    {}
func (*Exemplar) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{13}
}
func (m *Exemplar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Exemplar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Exemplar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Exemplar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Exemplar.Merge(m, src)
}
func (m *Exemplar) XXX_Size() int {
	return m.Size()
}
func (m *Exemplar) XXX_DiscardUnknown() {
	xxx_messageInfo_Exemplar.DiscardUnknown(m)
}

var xxx_messageInfo_Exemplar proto.InternalMessageInfo

type isExemplar_Value interface {
	isExemplar_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Exemplar_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,3,opt,name=as_double,json=asDouble,proto3,oneof" json:"as_double,omitempty"`
}
type Exemplar_AsInt struct {
	AsInt int64 `protobuf:"fixed64,6,opt,name=as_int,json=asInt,proto3,oneof" json:"as_int,omitempty"`
}

func (*Exemplar_AsDouble) isExemplar_Value() {}
func (*Exemplar_AsInt) isExemplar_Value()    {}

func (m *Exemplar) GetValue() isExemplar_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Exemplar) GetFilteredAttributes() []v11.KeyValue {
	if m != nil {
		return m.FilteredAttributes
	}
	return nil
}

func (m *Exemplar) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Exemplar) GetAsDouble() float64 {
	if x, ok := m.GetValue().(*Exemplar_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (m *Exemplar) GetAsInt() int64 {
	if x, ok := m.GetValue().(*Exemplar_AsInt); ok {
		return x.AsInt
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Exemplar) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Exemplar_AsDouble)(nil),
		(*Exemplar_AsInt)(nil),
	}
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.AggregationTemporality", AggregationTemporality_name, AggregationTemporality_value)
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.DataPointFlags", DataPointFlags_name, DataPointFlags_value)
	proto.RegisterType((*MetricsData)(nil), "opentelemetry.proto.metrics.v1.MetricsData")
	proto.RegisterType((*ResourceMetrics)(nil), "opentelemetry.proto.metrics.v1.ResourceMetrics")
	proto.RegisterType((*ScopeMetrics)(nil), "opentelemetry.proto.metrics.v1.ScopeMetrics")
	proto.RegisterType((*Metric)(nil), "opentelemetry.proto.metrics.v1.Metric")
	proto.RegisterType((*Gauge)(nil), "opentelemetry.proto.metrics.v1.Gauge")
	proto.RegisterType((*Sum)(nil), "opentelemetry.proto.metrics.v1.Sum")
	proto.RegisterType((*Histogram)(nil), "opentelemetry.proto.metrics.v1.Histogram")
	proto.RegisterType((*ExponentialHistogram)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogram")
	proto.RegisterType((*Summary)(nil), "opentelemetry.proto.metrics.v1.Summary")
	proto.RegisterType((*NumberDataPoint)(nil), "opentelemetry.proto.metrics.v1.NumberDataPoint")
	proto.RegisterType((*HistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint")
	proto.RegisterType((*ExponentialHistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint")
	proto.RegisterType((*ExponentialHistogramDataPoint_Buckets)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint.Buckets")
	proto.RegisterType((*SummaryDataPoint)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint")
	proto.RegisterType((*SummaryDataPoint_ValueAtQuantile)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint.ValueAtQuantile")
	proto.RegisterType((*Exemplar)(nil), "opentelemetry.proto.metrics.v1.Exemplar")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/metrics/v1/metrics.proto", fileDescriptor_3c3112f9fa006917)
}

var fileDescriptor_3c3112f9fa006917 = []byte{
	// 1490 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xcd, 0x6e, 0x1b, 0xbf,
	0x11, 0xd7, 0xea, 0x5b, 0x23, 0xd9, 0x56, 0x58, 0xd7, 0x11, 0x0c, 0x58, 0x51, 0x94, 0x36, 0x76,
	0x83, 0x40, 0xaa, 0x9d, 0xa2, 0x1f, 0x28, 0x02, 0x44, 0xb2, 0x64, 0x5b, 0x8e, 0xbf, 0x42, 0xcb,
	0x06, 0x12, 0x04, 0x59, 0xd0, 0x12, 0xad, 0x10, 0xd9, 0x25, 0xd5, 0x5d, 0xae, 0x61, 0xf7, 0x19,
	0x7a, 0xc8, 0x73, 0x14, 0xbd, 0xf5, 0x05, 0x7a, 0xcc, 0x31, 0xbd, 0x05, 0x45, 0x11, 0xb4, 0xce,
	0xa1, 0x2d, 0xfa, 0x12, 0x7f, 0x90, 0xbb, 0x6b, 0xc9, 0x8a, 0x1c, 0x39, 0xff, 0xe4, 0x90, 0x9c,
	0x96, 0x1c, 0xce, 0xfc, 0x38, 0xc3, 0xf9, 0x91, 0x33, 0x58, 0xb8, 0x2f, 0xfa, 0x94, 0x4b, 0x6a,
	0x51, 0x9b, 0x4a, 0xe7, 0xac, 0xda, 0x77, 0x84, 0x14, 0x55, 0x35, 0x66, 0x1d, 0xb7, 0x7a, 0xb2,
	0x1c, 0x0e, 0x2b, 0x7a, 0x01, 0x15, 0x2f, 0x69, 0xfb, 0xc2, 0x4a, 0xa8, 0x72, 0xb2, 0x3c, 0x3f,
	0xdb, 0x13, 0x3d, 0xe1, 0x63, 0xa8, 0x91, 0xaf, 0x30, 0x7f, 0x6f, 0xdc, 0x1e, 0x1d, 0x61, 0xdb,
	0x82, 0xab, 0x2d, 0xfc, 0x51, 0xa0, 0x5b, 0x19, 0xa7, 0xeb, 0x50, 0x57, 0x78, 0x4e, 0x87, 0x2a,
	0xed, 0x70, 0xec, 0xeb, 0x97, 0x19, 0x64, 0xb7, 0xfd, 0xfd, 0x1b, 0x44, 0x12, 0xf4, 0x0c, 0xf2,
	0xa1, 0x82, 0x19, 0xf8, 0x55, 0x30, 0x4a, 0xb1, 0xa5, 0xec, 0x4a, 0xb5, 0xf2, 0x69, 0xdf, 0x2b,
	0x38, 0xb0, 0x0b, 0xe0, 0xf0, 0x8c, 0x73, 0x59, 0x50, 0x7e, 0x67, 0xc0, 0xcc, 0x88, 0x12, 0x7a,
	0x0c, 0xe9, 0x50, 0xad, 0x60, 0x94, 0x8c, 0xa5, 0xec, 0xca, 0x2f, 0xc6, 0xee, 0x73, 0xe1, 0xf5,
	0xd0, 0x46, 0xf5, 0xf8, 0x9b, 0xf7, 0xb7, 0x22, 0xf8, 0x02, 0x00, 0x3d, 0x81, 0x29, 0xb7, 0x23,
	0xfa, 0x03, 0xcf, 0xa3, 0xda, 0xf3, 0xfb, 0x93, 0x3c, 0xdf, 0x57, 0x46, 0xa1, 0xdb, 0x39, 0x77,
	0x68, 0x86, 0x16, 0x00, 0xdc, 0xce, 0x4b, 0x6a, 0x13, 0xd3, 0x73, 0xac, 0x42, 0xac, 0x64, 0x2c,
	0x65, 0x70, 0xc6, 0x97, 0x1c, 0x38, 0xd6, 0x66, 0x32, 0xfd, 0xdf, 0x54, 0xfe, 0x7f, 0xa9, 0xf2,
	0xdf, 0x0c, 0xc8, 0x0d, 0xa3, 0xa0, 0x5d, 0x48, 0x68, 0x9c, 0x20, 0xa8, 0x07, 0x63, 0x5d, 0x08,
	0x12, 0x77, 0xb2, 0x5c, 0x69, 0x71, 0x57, 0x3a, 0x9e, 0x4d, 0xb9, 0x24, 0x92, 0x09, 0xae, 0xa1,
	0x82, 0xf0, 0x7c, 0x1c, 0xf4, 0x08, 0x52, 0x97, 0xa3, 0xba, 0x3b, 0x29, 0x2a, 0xdf, 0x15, 0x1c,
	0x9a, 0x4d, 0x08, 0xa5, 0xfc, 0xef, 0x18, 0x24, 0x7d, 0x13, 0x84, 0x20, 0xce, 0x89, 0xed, 0xfb,
	0x9e, 0xc1, 0x7a, 0x8c, 0x4a, 0x90, 0xed, 0x52, 0xb7, 0xe3, 0xb0, 0xbe, 0x72, 0xb0, 0x10, 0xd5,
	0x4b, 0xc3, 0x22, 0x65, 0xe5, 0x71, 0x26, 0x03, 0x64, 0x3d, 0x46, 0x0f, 0x21, 0xd1, 0x23, 0x5e,
	0x8f, 0x16, 0x12, 0xfa, 0x18, 0x7e, 0x3e, 0xc9, 0xe7, 0x75, 0xa5, 0xbc, 0x11, 0xc1, 0xbe, 0x15,
	0xfa, 0x0d, 0xc4, 0x5c, 0xcf, 0x2e, 0xa4, 0xb4, 0xf1, 0x9d, 0x89, 0x69, 0xf4, 0xec, 0x8d, 0x08,
	0x56, 0x16, 0xa8, 0x05, 0x99, 0x97, 0xcc, 0x95, 0xa2, 0xe7, 0x10, 0xbb, 0x90, 0xf9, 0x04, 0xaf,
	0x86, 0xcc, 0x37, 0x42, 0x83, 0x8d, 0x08, 0x1e, 0x58, 0xa3, 0x57, 0xf0, 0x53, 0x7a, 0xda, 0x17,
	0x9c, 0x72, 0xc9, 0x88, 0x65, 0x0e, 0x60, 0x41, 0xc3, 0xfe, 0x6a, 0x12, 0x6c, 0x73, 0x60, 0x3c,
	0xbc, 0xc3, 0x2c, 0x1d, 0x23, 0x47, 0xab, 0x90, 0x72, 0x3d, 0xdb, 0x26, 0xce, 0x59, 0x21, 0xab,
	0xe1, 0x17, 0xaf, 0x11, 0xb4, 0x52, 0xdf, 0x88, 0xe0, 0xd0, 0xb2, 0x9e, 0x84, 0x78, 0x97, 0x48,
	0xb2, 0x19, 0x4f, 0xc7, 0xf3, 0x89, 0xcd, 0x78, 0x3a, 0x99, 0x4f, 0x6d, 0xc6, 0xd3, 0xe9, 0x7c,
	0xa6, 0xfc, 0x14, 0x12, 0xfa, 0x84, 0xd1, 0x1e, 0x64, 0x95, 0x8a, 0xd9, 0x17, 0x8c, 0xcb, 0x6b,
	0xdf, 0xf0, 0x1d, 0xcf, 0x3e, 0xa2, 0x8e, 0x7a, 0x27, 0xf6, 0x94, 0x1d, 0x86, 0x6e, 0x38, 0x74,
	0xcb, 0xff, 0x37, 0x20, 0xb6, 0xef, 0xd9, 0x5f, 0x1f, 0x19, 0x09, 0xb8, 0x49, 0x7a, 0x3d, 0x87,
	0xf6, 0xf4, 0xd5, 0x30, 0x25, 0xb5, 0xfb, 0xc2, 0x21, 0x16, 0x93, 0x67, 0x9a, 0x85, 0xd3, 0x2b,
	0xbf, 0x9e, 0x84, 0x5e, 0x1b, 0x98, 0xb7, 0x07, 0xd6, 0x78, 0x8e, 0x8c, 0x95, 0xa3, 0xdb, 0x90,
	0x63, 0xae, 0x69, 0x0b, 0x2e, 0xa4, 0xe0, 0xac, 0xa3, 0x09, 0x9d, 0xc6, 0x59, 0xe6, 0x6e, 0x87,
	0xa2, 0xf2, 0xdf, 0x0d, 0xc8, 0x0c, 0xb2, 0xb6, 0x3f, 0x2e, 0xe6, 0x95, 0x6b, 0xf3, 0xed, 0xdb,
	0x08, 0xbb, 0xfc, 0x1f, 0x03, 0x66, 0xc7, 0x91, 0x15, 0xbd, 0x18, 0x17, 0xde, 0xc3, 0x1f, 0xc3,
	0xfb, 0x6f, 0x24, 0xd2, 0xe7, 0x90, 0x0a, 0xae, 0x0d, 0x7a, 0x32, 0x2e, 0xb6, 0x5f, 0x5e, 0xf3,
	0xd2, 0x8d, 0xbf, 0x09, 0xe7, 0x51, 0x98, 0x19, 0xe1, 0x33, 0xda, 0x06, 0x20, 0x52, 0x3a, 0xec,
	0xc8, 0x93, 0xd4, 0x2d, 0xa4, 0xf4, 0x2e, 0x8b, 0x13, 0x6a, 0xc2, 0x63, 0x7a, 0x76, 0x48, 0x2c,
	0x2f, 0xac, 0x03, 0x43, 0x00, 0xa8, 0x0a, 0xb3, 0xae, 0x24, 0x8e, 0x34, 0x25, 0xb3, 0xa9, 0xe9,
	0x71, 0x76, 0x6a, 0x72, 0xc2, 0x85, 0x3e, 0xae, 0x24, 0xbe, 0xa1, 0xd7, 0xda, 0xcc, 0xa6, 0x07,
	0x9c, 0x9d, 0xee, 0x10, 0x2e, 0xd0, 0xcf, 0x60, 0x7a, 0x44, 0x35, 0xa6, 0x55, 0x73, 0x72, 0x58,
	0x6b, 0x01, 0x32, 0xc4, 0x35, 0xbb, 0xc2, 0x3b, 0xb2, 0x68, 0x21, 0x5e, 0x32, 0x96, 0x8c, 0x8d,
	0x08, 0x4e, 0x13, 0xb7, 0xa1, 0x25, 0xe8, 0x26, 0x24, 0x89, 0x6b, 0x32, 0x2e, 0x0b, 0xc9, 0x92,
	0xb1, 0x94, 0x57, 0xcf, 0x34, 0x71, 0x5b, 0x5c, 0xa2, 0x2d, 0xc8, 0xd0, 0x53, 0x6a, 0xf7, 0x2d,
	0xe2, 0xb8, 0x85, 0x84, 0x0e, 0x6e, 0x69, 0x32, 0x3d, 0x7c, 0x83, 0x20, 0xba, 0x01, 0x00, 0x9a,
	0x85, 0xc4, 0xb1, 0x45, 0x7a, 0x6e, 0x21, 0x5d, 0x32, 0x96, 0xa6, 0xb0, 0x3f, 0xa9, 0xa7, 0x20,
	0x71, 0xa2, 0x4e, 0x63, 0x33, 0x9e, 0x36, 0xf2, 0xd1, 0xf2, 0x3f, 0x63, 0x80, 0x3e, 0xa6, 0xd5,
	0xc8, 0x39, 0x67, 0xbe, 0xd1, 0x73, 0x9e, 0x85, 0x44, 0x47, 0x78, 0x5c, 0xea, 0x33, 0x4e, 0x62,
	0x7f, 0x82, 0x90, 0x5f, 0xec, 0x12, 0xc1, 0xb9, 0xeb, 0x3a, 0x76, 0x07, 0xa6, 0x8e, 0xbc, 0xce,
	0x2b, 0x2a, 0x4d, 0xad, 0xe3, 0x16, 0x92, 0xa5, 0x98, 0x82, 0xf3, 0x85, 0xab, 0x5a, 0x86, 0x16,
	0x61, 0x86, 0x9e, 0xf6, 0x2d, 0xd6, 0x61, 0xd2, 0x3c, 0x12, 0x1e, 0xef, 0xfa, 0x0c, 0x33, 0xf0,
	0x74, 0x28, 0xae, 0x6b, 0xe9, 0xe5, 0x3c, 0xa5, 0xbf, 0x5a, 0x9e, 0x60, 0x28, 0x4f, 0x2a, 0x0a,
	0x9b, 0x71, 0x5d, 0xbd, 0x8c, 0x0d, 0x03, 0xab, 0x89, 0x96, 0x91, 0xd3, 0x42, 0x4e, 0xcb, 0xa2,
	0x58, 0x4d, 0x54, 0x91, 0x72, 0x3d, 0xdb, 0x54, 0x5f, 0x9b, 0x71, 0xff, 0x4b, 0x4e, 0xcd, 0x20,
	0xbd, 0xe7, 0x09, 0x58, 0xf8, 0xe4, 0x03, 0x32, 0x92, 0x69, 0xe3, 0xbb, 0xcf, 0xf4, 0xac, 0x6a,
	0x18, 0x89, 0x45, 0xf5, 0xdd, 0xba, 0x81, 0xfd, 0x89, 0xea, 0xd9, 0xfe, 0x48, 0x1d, 0xe1, 0x67,
	0x5f, 0xf7, 0x41, 0x49, 0x9c, 0x51, 0x12, 0x9d, 0x7a, 0xd4, 0x83, 0x74, 0x5f, 0xb8, 0x4c, 0xb2,
	0x13, 0xaa, 0x6f, 0x4b, 0x76, 0xa5, 0xf9, 0x45, 0xcf, 0x72, 0xa5, 0xae, 0x79, 0xe5, 0x86, 0x9d,
	0x75, 0x08, 0xae, 0x36, 0xe2, 0xfa, 0x21, 0x3d, 0xa1, 0x41, 0x3b, 0xf5, 0x75, 0x37, 0x0a, 0xc1,
	0xaf, 0x20, 0xd5, 0x25, 0xe2, 0x66, 0xbf, 0x94, 0xb8, 0x01, 0x45, 0x73, 0x63, 0x28, 0x3a, 0x35,
	0x44, 0xd1, 0xf9, 0x35, 0x48, 0x05, 0x6e, 0xa2, 0x39, 0x48, 0x8a, 0xe3, 0x63, 0x97, 0x4a, 0xdd,
	0x13, 0xdf, 0xc0, 0xc1, 0xec, 0xe3, 0xfb, 0xa9, 0x7a, 0xf3, 0xf8, 0xe5, 0xfb, 0x79, 0x15, 0xd5,
	0xcb, 0x7f, 0x89, 0x41, 0x7e, 0xb4, 0x92, 0x7c, 0x27, 0x95, 0x62, 0x3c, 0xaf, 0xf3, 0x43, 0xbc,
	0xf6, 0x59, 0xcd, 0x60, 0xe6, 0x0f, 0x1e, 0xe1, 0x92, 0x59, 0xd4, 0xd4, 0xcf, 0xb7, 0xff, 0x82,
	0x65, 0x57, 0x1e, 0x7d, 0x6e, 0x89, 0xad, 0xe8, 0x08, 0x6b, 0xf2, 0x49, 0x00, 0x87, 0xa7, 0x43,
	0x60, 0xbd, 0x70, 0x45, 0xd9, 0x98, 0x5f, 0x85, 0x99, 0x11, 0x43, 0x34, 0x0f, 0xe9, 0xd0, 0x54,
	0x67, 0xd3, 0xc0, 0x17, 0x73, 0x05, 0xa2, 0xdd, 0xd4, 0xe7, 0x63, 0xe0, 0x4b, 0x25, 0xe7, 0x75,
	0x0c, 0xd2, 0x21, 0xa9, 0xd0, 0x0b, 0xf8, 0xc9, 0x31, 0xb3, 0x24, 0x75, 0x68, 0xd7, 0xfc, 0xd2,
	0x7c, 0xa1, 0x10, 0xa9, 0x36, 0xc8, 0xdb, 0xc7, 0x69, 0x88, 0x4e, 0x2a, 0xd8, 0xb1, 0xeb, 0x17,
	0xec, 0xa7, 0x90, 0x72, 0xfb, 0x84, 0x9b, 0xac, 0xab, 0x13, 0x98, 0xab, 0x3f, 0x52, 0x8e, 0xfc,
	0xe3, 0xfd, 0xad, 0xdf, 0xf6, 0xc4, 0x88, 0xef, 0x4c, 0x54, 0x3b, 0xc2, 0xb2, 0x68, 0x47, 0x0a,
	0xa7, 0xda, 0x57, 0x6d, 0x4e, 0x95, 0x71, 0x49, 0x1d, 0x4e, 0xac, 0xaa, 0x9a, 0x55, 0xf6, 0xfb,
	0x84, 0xb7, 0x1a, 0x38, 0xa9, 0x00, 0x5b, 0x5d, 0xf4, 0x1c, 0xd2, 0xd2, 0x21, 0x1d, 0xaa, 0xb0,
	0x13, 0x1a, 0xbb, 0x16, 0x60, 0xff, 0xee, 0xf3, 0xb1, 0xdb, 0x0a, 0xa9, 0xd5, 0xc0, 0x29, 0x0d,
	0xd9, 0xea, 0x8e, 0x74, 0x01, 0xf7, 0xfe, 0x64, 0xc0, 0xdc, 0xf8, 0xde, 0x0f, 0x2d, 0xc2, 0x9d,
	0xda, 0xfa, 0x3a, 0x6e, 0xae, 0xd7, 0xda, 0xad, 0xdd, 0x1d, 0xb3, 0xdd, 0xdc, 0xde, 0xdb, 0xc5,
	0xb5, 0xad, 0x56, 0xfb, 0xa9, 0x79, 0xb0, 0xb3, 0xbf, 0xd7, 0x5c, 0x6d, 0xad, 0xb5, 0x9a, 0x8d,
	0x7c, 0x04, 0xdd, 0x86, 0x85, 0xab, 0x14, 0x1b, 0xcd, 0xad, 0x76, 0x2d, 0x6f, 0xa0, 0xbb, 0x50,
	0xbe, 0x4a, 0x65, 0xf5, 0x60, 0xfb, 0x60, 0xab, 0xd6, 0x6e, 0x1d, 0x36, 0xf3, 0xd1, 0x7b, 0xbf,
	0x87, 0xe9, 0x0b, 0xbe, 0xae, 0xe9, 0x87, 0x6b, 0x0a, 0x32, 0x6b, 0x5b, 0xb5, 0x75, 0x73, 0x67,
	0x77, 0xa7, 0x99, 0x8f, 0xa0, 0x79, 0x98, 0x0b, 0xa6, 0x26, 0x6e, 0xae, 0xee, 0xe2, 0x46, 0xb3,
	0x61, 0x1e, 0xd6, 0xb6, 0x0e, 0x9a, 0x79, 0xa3, 0xfe, 0x57, 0xe3, 0xcd, 0x79, 0xd1, 0x78, 0x7b,
	0x5e, 0x34, 0xfe, 0x75, 0x5e, 0x34, 0x5e, 0x7f, 0x28, 0x46, 0xde, 0x7e, 0x28, 0x46, 0xde, 0x7d,
	0x28, 0x46, 0xe0, 0x36, 0x13, 0x13, 0xae, 0x4b, 0x3d, 0x17, 0xfc, 0x78, 0xd8, 0x53, 0x0b, 0x7b,
	0xc6, 0xb3, 0xe6, 0x67, 0x1f, 0xb6, 0xff, 0xab, 0xa8, 0x47, 0xf9, 0xd0, 0xdf, 0xab, 0x3f, 0x47,
	0x8b, 0xbb, 0x7d, 0xca, 0xdb, 0x17, 0x20, 0x1a, 0x3e, 0xf8, 0xb3, 0xe0, 0x56, 0x0e, 0x97, 0x8f,
	0x92, 0xda, 0xea, 0xc1, 0x0f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xd6, 0x26, 0xf7, 0xb5, 0x07, 0x13,
	0x00, 0x00,
}

func (m *MetricsData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricsData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceMetrics) > 0 {
		for iNdEx := len(m.ResourceMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ScopeMetrics) > 0 {
		for iNdEx := len(m.ScopeMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ScopeMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *ScopeMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScopeMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScopeMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Scope.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Metric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metric) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Unit) > 0 {
		i -= len(m.Unit)
		copy(dAtA[i:], m.Unit)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Unit)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Metric_Gauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Gauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Gauge != nil {
		{
			size, err := m.Gauge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Sum != nil {
		{
			size, err := m.Sum.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Histogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Histogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Histogram != nil {
		{
			size, err := m.Histogram.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_ExponentialHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_ExponentialHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExponentialHistogram != nil {
		{
			size, err := m.ExponentialHistogram.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Summary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Summary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Summary != nil {
		{
			size, err := m.Summary.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Gauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Gauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Gauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Sum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsMonotonic {
		i--
		if m.IsMonotonic {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Histogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Histogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Histogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExponentialHistogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Summary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Summary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Summary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NumberDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NumberDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	return len(dAtA) - i, nil
}

func (m *NumberDataPoint_AsDouble) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint_AsDouble) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AsDouble))))
	i--
	dAtA[i] = 0x21
	return len(dAtA) - i, nil
}
func (m *NumberDataPoint_AsInt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint_AsInt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.AsInt))
	i--
	dAtA[i] = 0x31
	return len(dAtA) - i, nil
}
func (m *HistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Max_ != nil {
		{
			size := m.Max_.Size()
			i -= size
			if _, err := m.Max_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Min_ != nil {
		{
			size := m.Min_.Size()
			i -= size
			if _, err := m.Min_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x50
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.ExplicitBounds) > 0 {
		for iNdEx := len(m.ExplicitBounds) - 1; iNdEx >= 0; iNdEx-- {
			f8 := math.Float64bits(float64(m.ExplicitBounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f8))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.ExplicitBounds)*8))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.BucketCounts) > 0 {
		for iNdEx := len(m.BucketCounts) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.BucketCounts[iNdEx]))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.BucketCounts)*8))
		i--
		dAtA[i] = 0x32
	}
	if m.Sum_ != nil {
		{
			size := m.Sum_.Size()
			i -= size
			if _, err := m.Sum_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	return len(dAtA) - i, nil
}

func (m *HistogramDataPoint_Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint_Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
	i--
	dAtA[i] = 0x29
	return len(dAtA) - i, nil
}
func (m *HistogramDataPoint_Min) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint_Min) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Min))))
	i--
	dAtA[i] = 0x59
	return len(dAtA) - i, nil
}
func (m *HistogramDataPoint_Max) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint_Max) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Max))))
	i--
	dAtA[i] = 0x61
	return len(dAtA) - i, nil
}
func (m *ExponentialHistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Max_ != nil {
		{
			size := m.Max_.Size()
			i -= size
			if _, err := m.Max_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Min_ != nil {
		{
			size := m.Min_.Size()
			i -= size
			if _, err := m.Min_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x50
	}
	{
		size, err := m.Negative.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x4a
	{
		size, err := m.Positive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if m.ZeroCount != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ZeroCount))
		i--
		dAtA[i] = 0x39
	}
	if m.Scale != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64((uint32(m.Scale)<<1)^uint32((m.Scale>>31))))
		i--
		dAtA[i] = 0x30
	}
	if m.Sum_ != nil {
		{
			size := m.Sum_.Size()
			i -= size
			if _, err := m.Sum_.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExponentialHistogramDataPoint_Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint_Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
	i--
	dAtA[i] = 0x29
	return len(dAtA) - i, nil
}
func (m *ExponentialHistogramDataPoint_Min) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint_Min) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Min))))
	i--
	dAtA[i] = 0x61
	return len(dAtA) - i, nil
}
func (m *ExponentialHistogramDataPoint_Max) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint_Max) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Max))))
	i--
	dAtA[i] = 0x69
	return len(dAtA) - i, nil
}
func (m *ExponentialHistogramDataPoint_Buckets) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogramDataPoint_Buckets) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint_Buckets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BucketCounts) > 0 {
		dAtA12 := make([]byte, len(m.BucketCounts)*10)
		var j11 int
		for _, num := range m.BucketCounts {
			for num >= 1<<7 {
				dAtA12[j11] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j11++
			}
			dAtA12[j11] = uint8(num)
			j11++
		}
		i -= j11
		copy(dAtA[i:], dAtA12[:j11])
		i = encodeVarintMetrics(dAtA, i, uint64(j11))
		i--
		dAtA[i] = 0x12
	}
	if m.Offset != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64((uint32(m.Offset)<<1)^uint32((m.Offset>>31))))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.QuantileValues) > 0 {
		for iNdEx := len(m.QuantileValues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QuantileValues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint_ValueAtQuantile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint_ValueAtQuantile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint_ValueAtQuantile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x11
	}
	if m.Quantile != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Quantile))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *Exemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Exemplar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FilteredAttributes) > 0 {
		for iNdEx := len(m.FilteredAttributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FilteredAttributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	return len(dAtA) - i, nil
}

func (m *Exemplar_AsDouble) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar_AsDouble) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AsDouble))))
	i--
	dAtA[i] = 0x19
	return len(dAtA) - i, nil
}
func (m *Exemplar_AsInt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar_AsInt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.AsInt))
	i--
	dAtA[i] = 0x31
	return len(dAtA) - i, nil
}
func encodeVarintMetrics(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetrics(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MetricsData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceMetrics) > 0 {
		for _, e := range m.ResourceMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *ResourceMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.ScopeMetrics) > 0 {
		for _, e := range m.ScopeMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}

func (m *ScopeMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Scope.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}

func (m *Metric) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *Metric_Gauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gauge != nil {
		l = m.Gauge.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sum != nil {
		l = m.Sum.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Histogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Histogram != nil {
		l = m.Histogram.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_ExponentialHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExponentialHistogram != nil {
		l = m.ExponentialHistogram.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Summary != nil {
		l = m.Summary.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Gauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	if m.IsMonotonic {
		n += 2
	}
	return n
}

func (m *Histogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *ExponentialHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *NumberDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	return n
}

func (m *NumberDataPoint_AsDouble) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *NumberDataPoint_AsInt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *HistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum_ != nil {
		n += m.Sum_.Size()
	}
	if len(m.BucketCounts) > 0 {
		n += 1 + sovMetrics(uint64(len(m.BucketCounts)*8)) + len(m.BucketCounts)*8
	}
	if len(m.ExplicitBounds) > 0 {
		n += 1 + sovMetrics(uint64(len(m.ExplicitBounds)*8)) + len(m.ExplicitBounds)*8
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	if m.Min_ != nil {
		n += m.Min_.Size()
	}
	if m.Max_ != nil {
		n += m.Max_.Size()
	}
	return n
}

func (m *HistogramDataPoint_Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *HistogramDataPoint_Min) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *HistogramDataPoint_Max) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *ExponentialHistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum_ != nil {
		n += m.Sum_.Size()
	}
	if m.Scale != 0 {
		n += 1 + sozMetrics(uint64(m.Scale))
	}
	if m.ZeroCount != 0 {
		n += 9
	}
	l = m.Positive.Size()
	n += 1 + l + sovMetrics(uint64(l))
	l = m.Negative.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Min_ != nil {
		n += m.Min_.Size()
	}
	if m.Max_ != nil {
		n += m.Max_.Size()
	}
	return n
}

func (m *ExponentialHistogramDataPoint_Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *ExponentialHistogramDataPoint_Min) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *ExponentialHistogramDataPoint_Max) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *ExponentialHistogramDataPoint_Buckets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Offset != 0 {
		n += 1 + sozMetrics(uint64(m.Offset))
	}
	if len(m.BucketCounts) > 0 {
		l = 0
		for _, e := range m.BucketCounts {
			l += sovMetrics(uint64(e))
		}
		n += 1 + sovMetrics(uint64(l)) + l
	}
	return n
}

func (m *SummaryDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.QuantileValues) > 0 {
		for _, e := range m.QuantileValues {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	return n
}

func (m *SummaryDataPoint_ValueAtQuantile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Quantile != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *Exemplar) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	l = m.SpanId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	l = m.TraceId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.FilteredAttributes) > 0 {
		for _, e := range m.FilteredAttributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *Exemplar_AsDouble) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Exemplar_AsInt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}

func sovMetrics(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetrics(x uint64) (n int) {
	return sovMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MetricsData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceMetrics = append(m.ResourceMetrics, &ResourceMetrics{})
			if err := m.ResourceMetrics[len(m.ResourceMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScopeMetrics = append(m.ScopeMetrics, &ScopeMetrics{})
			if err := m.ScopeMetrics[len(m.ScopeMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScopeMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScopeMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScopeMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Scope.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metric) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metric: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metric: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gauge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Gauge{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Gauge{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Sum{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Sum{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Histogram", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Histogram{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Histogram{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialHistogram", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExponentialHistogram{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_ExponentialHistogram{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Summary{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Summary{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Gauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Gauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Gauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &NumberDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &NumberDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsMonotonic", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsMonotonic = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Histogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Histogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Histogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &HistogramDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExponentialHistogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExponentialHistogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &ExponentialHistogramDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Summary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Summary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Summary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &SummaryDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NumberDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NumberDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NumberDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &NumberDataPoint_AsDouble{float64(math.Float64frombits(v))}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var v int64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &NumberDataPoint_AsInt{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum_ = &HistogramDataPoint_Sum{float64(math.Float64frombits(v))}
		case 6:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.BucketCounts = append(m.BucketCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.BucketCounts) == 0 {
					m.BucketCounts = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.BucketCounts = append(m.BucketCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		case 7:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.ExplicitBounds = append(m.ExplicitBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.ExplicitBounds) == 0 {
					m.ExplicitBounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.ExplicitBounds = append(m.ExplicitBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Min_ = &HistogramDataPoint_Min{float64(math.Float64frombits(v))}
		case 12:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Max_ = &HistogramDataPoint_Max{float64(math.Float64frombits(v))}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExponentialHistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExponentialHistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum_ = &ExponentialHistogramDataPoint_Sum{float64(math.Float64frombits(v))}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Scale = v
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroCount", wireType)
			}
			m.ZeroCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ZeroCount = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Positive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Positive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Negative", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Negative.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Min_ = &ExponentialHistogramDataPoint_Min{float64(math.Float64frombits(v))}
		case 13:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Max_ = &ExponentialHistogramDataPoint_Max{float64(math.Float64frombits(v))}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogramDataPoint_Buckets) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Buckets: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Buckets: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Offset = v
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.BucketCounts = append(m.BucketCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.BucketCounts) == 0 {
					m.BucketCounts = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetrics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.BucketCounts = append(m.BucketCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SummaryDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SummaryDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuantileValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuantileValues = append(m.QuantileValues, &SummaryDataPoint_ValueAtQuantile{})
			if err := m.QuantileValues[len(m.QuantileValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint_ValueAtQuantile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueAtQuantile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueAtQuantile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Quantile = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Exemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Exemplar_AsDouble{float64(math.Float64frombits(v))}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var v int64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Exemplar_AsInt{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilteredAttributes = append(m.FilteredAttributes, v11.KeyValue{})
			if err := m.FilteredAttributes[len(m.FilteredAttributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetrics
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetrics
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetrics        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetrics          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetrics = fmt.Errorf("proto: unexpected end of group")
)
