// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

type ResourceSpansSlice struct {
	orig *[]*otlptrace.ResourceSpans
}

func GetOrigResourceSpansSlice(ms ResourceSpansSlice) *[]*otlptrace.ResourceSpans {
	return ms.orig
}

func NewResourceSpansSlice(orig *[]*otlptrace.ResourceSpans) ResourceSpansSlice {
	return ResourceSpansSlice{orig: orig}
}

type ResourceSpans struct {
	orig *otlptrace.ResourceSpans
}

func GetOrigResourceSpans(ms ResourceSpans) *otlptrace.ResourceSpans {
	return ms.orig
}

func NewResourceSpans(orig *otlptrace.ResourceSpans) ResourceSpans {
	return ResourceSpans{orig: orig}
}

type ScopeSpansSlice struct {
	orig *[]*otlptrace.ScopeSpans
}

func GetOrigScopeSpansSlice(ms ScopeSpansSlice) *[]*otlptrace.ScopeSpans {
	return ms.orig
}

func NewScopeSpansSlice(orig *[]*otlptrace.ScopeSpans) ScopeSpansSlice {
	return ScopeSpansSlice{orig: orig}
}

type ScopeSpans struct {
	orig *otlptrace.ScopeSpans
}

func GetOrigScopeSpans(ms ScopeSpans) *otlptrace.ScopeSpans {
	return ms.orig
}

func NewScopeSpans(orig *otlptrace.ScopeSpans) ScopeSpans {
	return ScopeSpans{orig: orig}
}

type SpanSlice struct {
	orig *[]*otlptrace.Span
}

func GetOrigSpanSlice(ms SpanSlice) *[]*otlptrace.Span {
	return ms.orig
}

func NewSpanSlice(orig *[]*otlptrace.Span) SpanSlice {
	return SpanSlice{orig: orig}
}

type Span struct {
	orig *otlptrace.Span
}

func GetOrigSpan(ms Span) *otlptrace.Span {
	return ms.orig
}

func NewSpan(orig *otlptrace.Span) Span {
	return Span{orig: orig}
}

type SpanEventSlice struct {
	orig *[]*otlptrace.Span_Event
}

func GetOrigSpanEventSlice(ms SpanEventSlice) *[]*otlptrace.Span_Event {
	return ms.orig
}

func NewSpanEventSlice(orig *[]*otlptrace.Span_Event) SpanEventSlice {
	return SpanEventSlice{orig: orig}
}

type SpanEvent struct {
	orig *otlptrace.Span_Event
}

func GetOrigSpanEvent(ms SpanEvent) *otlptrace.Span_Event {
	return ms.orig
}

func NewSpanEvent(orig *otlptrace.Span_Event) SpanEvent {
	return SpanEvent{orig: orig}
}

type SpanLinkSlice struct {
	orig *[]*otlptrace.Span_Link
}

func GetOrigSpanLinkSlice(ms SpanLinkSlice) *[]*otlptrace.Span_Link {
	return ms.orig
}

func NewSpanLinkSlice(orig *[]*otlptrace.Span_Link) SpanLinkSlice {
	return SpanLinkSlice{orig: orig}
}

type SpanLink struct {
	orig *otlptrace.Span_Link
}

func GetOrigSpanLink(ms SpanLink) *otlptrace.Span_Link {
	return ms.orig
}

func NewSpanLink(orig *otlptrace.Span_Link) SpanLink {
	return SpanLink{orig: orig}
}

type SpanStatus struct {
	orig *otlptrace.Status
}

func GetOrigSpanStatus(ms SpanStatus) *otlptrace.Status {
	return ms.orig
}

func NewSpanStatus(orig *otlptrace.Status) SpanStatus {
	return SpanStatus{orig: orig}
}

func GenerateTestResourceSpansSlice() ResourceSpansSlice {
	orig := []*otlptrace.ResourceSpans{}
	tv := NewResourceSpansSlice(&orig)
	FillTestResourceSpansSlice(tv)
	return tv
}

func FillTestResourceSpansSlice(tv ResourceSpansSlice) {
	*tv.orig = make([]*otlptrace.ResourceSpans, 7)
	for i := 0; i < 7; i++ {
		(*tv.orig)[i] = &otlptrace.ResourceSpans{}
		FillTestResourceSpans(NewResourceSpans((*tv.orig)[i]))
	}
}

func GenerateTestResourceSpans() ResourceSpans {
	orig := otlptrace.ResourceSpans{}
	tv := NewResourceSpans(&orig)
	FillTestResourceSpans(tv)
	return tv
}

func FillTestResourceSpans(tv ResourceSpans) {
	FillTestResource(NewResource(&tv.orig.Resource))
	tv.orig.SchemaUrl = "https://opentelemetry.io/schemas/1.5.0"
	FillTestScopeSpansSlice(NewScopeSpansSlice(&tv.orig.ScopeSpans))
}

func GenerateTestScopeSpansSlice() ScopeSpansSlice {
	orig := []*otlptrace.ScopeSpans{}
	tv := NewScopeSpansSlice(&orig)
	FillTestScopeSpansSlice(tv)
	return tv
}

func FillTestScopeSpansSlice(tv ScopeSpansSlice) {
	*tv.orig = make([]*otlptrace.ScopeSpans, 7)
	for i := 0; i < 7; i++ {
		(*tv.orig)[i] = &otlptrace.ScopeSpans{}
		FillTestScopeSpans(NewScopeSpans((*tv.orig)[i]))
	}
}

func GenerateTestScopeSpans() ScopeSpans {
	orig := otlptrace.ScopeSpans{}
	tv := NewScopeSpans(&orig)
	FillTestScopeSpans(tv)
	return tv
}

func FillTestScopeSpans(tv ScopeSpans) {
	FillTestInstrumentationScope(NewInstrumentationScope(&tv.orig.Scope))
	tv.orig.SchemaUrl = "https://opentelemetry.io/schemas/1.5.0"
	FillTestSpanSlice(NewSpanSlice(&tv.orig.Spans))
}

func GenerateTestSpanSlice() SpanSlice {
	orig := []*otlptrace.Span{}
	tv := NewSpanSlice(&orig)
	FillTestSpanSlice(tv)
	return tv
}

func FillTestSpanSlice(tv SpanSlice) {
	*tv.orig = make([]*otlptrace.Span, 7)
	for i := 0; i < 7; i++ {
		(*tv.orig)[i] = &otlptrace.Span{}
		FillTestSpan(NewSpan((*tv.orig)[i]))
	}
}

func GenerateTestSpan() Span {
	orig := otlptrace.Span{}
	tv := NewSpan(&orig)
	FillTestSpan(tv)
	return tv
}

func FillTestSpan(tv Span) {
	tv.orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	tv.orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	FillTestTraceState(NewTraceState(&tv.orig.TraceState))
	tv.orig.ParentSpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	tv.orig.Name = "test_name"
	tv.orig.Kind = otlptrace.Span_SpanKind(3)
	tv.orig.StartTimeUnixNano = 1234567890
	tv.orig.EndTimeUnixNano = 1234567890
	FillTestMap(NewMap(&tv.orig.Attributes))
	tv.orig.DroppedAttributesCount = uint32(17)
	FillTestSpanEventSlice(NewSpanEventSlice(&tv.orig.Events))
	tv.orig.DroppedEventsCount = uint32(17)
	FillTestSpanLinkSlice(NewSpanLinkSlice(&tv.orig.Links))
	tv.orig.DroppedLinksCount = uint32(17)
	FillTestSpanStatus(NewSpanStatus(&tv.orig.Status))
}

func GenerateTestSpanEventSlice() SpanEventSlice {
	orig := []*otlptrace.Span_Event{}
	tv := NewSpanEventSlice(&orig)
	FillTestSpanEventSlice(tv)
	return tv
}

func FillTestSpanEventSlice(tv SpanEventSlice) {
	*tv.orig = make([]*otlptrace.Span_Event, 7)
	for i := 0; i < 7; i++ {
		(*tv.orig)[i] = &otlptrace.Span_Event{}
		FillTestSpanEvent(NewSpanEvent((*tv.orig)[i]))
	}
}

func GenerateTestSpanEvent() SpanEvent {
	orig := otlptrace.Span_Event{}
	tv := NewSpanEvent(&orig)
	FillTestSpanEvent(tv)
	return tv
}

func FillTestSpanEvent(tv SpanEvent) {
	tv.orig.TimeUnixNano = 1234567890
	tv.orig.Name = "test_name"
	FillTestMap(NewMap(&tv.orig.Attributes))
	tv.orig.DroppedAttributesCount = uint32(17)
}

func GenerateTestSpanLinkSlice() SpanLinkSlice {
	orig := []*otlptrace.Span_Link{}
	tv := NewSpanLinkSlice(&orig)
	FillTestSpanLinkSlice(tv)
	return tv
}

func FillTestSpanLinkSlice(tv SpanLinkSlice) {
	*tv.orig = make([]*otlptrace.Span_Link, 7)
	for i := 0; i < 7; i++ {
		(*tv.orig)[i] = &otlptrace.Span_Link{}
		FillTestSpanLink(NewSpanLink((*tv.orig)[i]))
	}
}

func GenerateTestSpanLink() SpanLink {
	orig := otlptrace.Span_Link{}
	tv := NewSpanLink(&orig)
	FillTestSpanLink(tv)
	return tv
}

func FillTestSpanLink(tv SpanLink) {
	tv.orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	tv.orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	FillTestTraceState(NewTraceState(&tv.orig.TraceState))
	FillTestMap(NewMap(&tv.orig.Attributes))
	tv.orig.DroppedAttributesCount = uint32(17)
}

func GenerateTestSpanStatus() SpanStatus {
	orig := otlptrace.Status{}
	tv := NewSpanStatus(&orig)
	FillTestSpanStatus(tv)
	return tv
}

func FillTestSpanStatus(tv SpanStatus) {
	tv.orig.Code = 1
	tv.orig.Message = "cancelled"
}
