// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "model/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run model/internal/cmd/pdatagen/main.go".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestResourceMetricsSlice(t *testing.T) {
	es := NewResourceMetricsSlice()
	assert.Equal(t, 0, es.Len())
	es = newResourceMetricsSlice(&[]*otlpmetrics.ResourceMetrics{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newResourceMetrics(&otlpmetrics.ResourceMetrics{})
	testVal := ResourceMetrics(internal.GenerateTestResourceMetrics())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestResourceMetrics(internal.ResourceMetrics(el))
		assert.Equal(t, testVal, el)
	}
}

func TestResourceMetricsSlice_CopyTo(t *testing.T) {
	dest := NewResourceMetricsSlice()
	// Test CopyTo to empty
	NewResourceMetricsSlice().CopyTo(dest)
	assert.Equal(t, NewResourceMetricsSlice(), dest)

	// Test CopyTo larger slice
	ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()).CopyTo(dest)
	assert.Equal(t, ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()), dest)

	// Test CopyTo same size slice
	ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()).CopyTo(dest)
	assert.Equal(t, ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()), dest)
}

func TestResourceMetricsSlice_EnsureCapacity(t *testing.T) {
	es := ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ResourceMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ResourceMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.ResourceMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestResourceMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice())
	dest := NewResourceMetricsSlice()
	src := ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestResourceMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewResourceMetricsSlice()
	emptySlice.RemoveIf(func(el ResourceMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := ResourceMetricsSlice(internal.GenerateTestResourceMetricsSlice())
	pos := 0
	filtered.RemoveIf(func(el ResourceMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestResourceMetrics_MoveTo(t *testing.T) {
	ms := ResourceMetrics(internal.GenerateTestResourceMetrics())
	dest := NewResourceMetrics()
	ms.MoveTo(dest)
	assert.Equal(t, NewResourceMetrics(), ms)
	assert.Equal(t, ResourceMetrics(internal.GenerateTestResourceMetrics()), dest)
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	orig := NewResourceMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = ResourceMetrics(internal.GenerateTestResourceMetrics())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	internal.FillTestResource(internal.Resource(ms.Resource()))
	assert.Equal(t, pcommon.Resource(internal.GenerateTestResource()), ms.Resource())
}

func TestResourceMetrics_SchemaUrl(t *testing.T) {
	ms := NewResourceMetrics()
	assert.Equal(t, "", ms.SchemaUrl())
	ms.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	assert.Equal(t, "https://opentelemetry.io/schemas/1.5.0", ms.SchemaUrl())
}

func TestResourceMetrics_ScopeMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.Equal(t, NewScopeMetricsSlice(), ms.ScopeMetrics())
	internal.FillTestScopeMetricsSlice(internal.ScopeMetricsSlice(ms.ScopeMetrics()))
	assert.Equal(t, ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()), ms.ScopeMetrics())
}

func TestScopeMetricsSlice(t *testing.T) {
	es := NewScopeMetricsSlice()
	assert.Equal(t, 0, es.Len())
	es = newScopeMetricsSlice(&[]*otlpmetrics.ScopeMetrics{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newScopeMetrics(&otlpmetrics.ScopeMetrics{})
	testVal := ScopeMetrics(internal.GenerateTestScopeMetrics())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestScopeMetrics(internal.ScopeMetrics(el))
		assert.Equal(t, testVal, el)
	}
}

func TestScopeMetricsSlice_CopyTo(t *testing.T) {
	dest := NewScopeMetricsSlice()
	// Test CopyTo to empty
	NewScopeMetricsSlice().CopyTo(dest)
	assert.Equal(t, NewScopeMetricsSlice(), dest)

	// Test CopyTo larger slice
	ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()).CopyTo(dest)
	assert.Equal(t, ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()), dest)

	// Test CopyTo same size slice
	ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()).CopyTo(dest)
	assert.Equal(t, ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()), dest)
}

func TestScopeMetricsSlice_EnsureCapacity(t *testing.T) {
	es := ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ScopeMetrics]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ScopeMetrics]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ScopeMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.ScopeMetrics]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestScopeMetricsSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice())
	dest := NewScopeMetricsSlice()
	src := ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestScopeMetricsSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewScopeMetricsSlice()
	emptySlice.RemoveIf(func(el ScopeMetrics) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := ScopeMetricsSlice(internal.GenerateTestScopeMetricsSlice())
	pos := 0
	filtered.RemoveIf(func(el ScopeMetrics) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestScopeMetrics_MoveTo(t *testing.T) {
	ms := ScopeMetrics(internal.GenerateTestScopeMetrics())
	dest := NewScopeMetrics()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeMetrics(), ms)
	assert.Equal(t, ScopeMetrics(internal.GenerateTestScopeMetrics()), dest)
}

func TestScopeMetrics_CopyTo(t *testing.T) {
	ms := NewScopeMetrics()
	orig := NewScopeMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = ScopeMetrics(internal.GenerateTestScopeMetrics())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestScopeMetrics_Scope(t *testing.T) {
	ms := NewScopeMetrics()
	internal.FillTestInstrumentationScope(internal.InstrumentationScope(ms.Scope()))
	assert.Equal(t, pcommon.InstrumentationScope(internal.GenerateTestInstrumentationScope()), ms.Scope())
}

func TestScopeMetrics_SchemaUrl(t *testing.T) {
	ms := NewScopeMetrics()
	assert.Equal(t, "", ms.SchemaUrl())
	ms.SetSchemaUrl("https://opentelemetry.io/schemas/1.5.0")
	assert.Equal(t, "https://opentelemetry.io/schemas/1.5.0", ms.SchemaUrl())
}

func TestScopeMetrics_Metrics(t *testing.T) {
	ms := NewScopeMetrics()
	assert.Equal(t, NewMetricSlice(), ms.Metrics())
	internal.FillTestMetricSlice(internal.MetricSlice(ms.Metrics()))
	assert.Equal(t, MetricSlice(internal.GenerateTestMetricSlice()), ms.Metrics())
}

func TestMetricSlice(t *testing.T) {
	es := NewMetricSlice()
	assert.Equal(t, 0, es.Len())
	es = newMetricSlice(&[]*otlpmetrics.Metric{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newMetric(&otlpmetrics.Metric{})
	testVal := Metric(internal.GenerateTestMetric())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestMetric(internal.Metric(el))
		assert.Equal(t, testVal, el)
	}
}

func TestMetricSlice_CopyTo(t *testing.T) {
	dest := NewMetricSlice()
	// Test CopyTo to empty
	NewMetricSlice().CopyTo(dest)
	assert.Equal(t, NewMetricSlice(), dest)

	// Test CopyTo larger slice
	MetricSlice(internal.GenerateTestMetricSlice()).CopyTo(dest)
	assert.Equal(t, MetricSlice(internal.GenerateTestMetricSlice()), dest)

	// Test CopyTo same size slice
	MetricSlice(internal.GenerateTestMetricSlice()).CopyTo(dest)
	assert.Equal(t, MetricSlice(internal.GenerateTestMetricSlice()), dest)
}

func TestMetricSlice_EnsureCapacity(t *testing.T) {
	es := MetricSlice(internal.GenerateTestMetricSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Metric]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Metric]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.Metric]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestMetricSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := MetricSlice(internal.GenerateTestMetricSlice())
	dest := NewMetricSlice()
	src := MetricSlice(internal.GenerateTestMetricSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, MetricSlice(internal.GenerateTestMetricSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, MetricSlice(internal.GenerateTestMetricSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	MetricSlice(internal.GenerateTestMetricSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestMetricSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewMetricSlice()
	emptySlice.RemoveIf(func(el Metric) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := MetricSlice(internal.GenerateTestMetricSlice())
	pos := 0
	filtered.RemoveIf(func(el Metric) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestMetric_MoveTo(t *testing.T) {
	ms := Metric(internal.GenerateTestMetric())
	dest := NewMetric()
	ms.MoveTo(dest)
	assert.Equal(t, NewMetric(), ms)
	assert.Equal(t, Metric(internal.GenerateTestMetric()), dest)
}

func TestMetric_CopyTo(t *testing.T) {
	ms := NewMetric()
	orig := NewMetric()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Metric(internal.GenerateTestMetric())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestMetric_Name(t *testing.T) {
	ms := NewMetric()
	assert.Equal(t, "", ms.Name())
	ms.SetName("test_name")
	assert.Equal(t, "test_name", ms.Name())
}

func TestMetric_Description(t *testing.T) {
	ms := NewMetric()
	assert.Equal(t, "", ms.Description())
	ms.SetDescription("test_description")
	assert.Equal(t, "test_description", ms.Description())
}

func TestMetric_Unit(t *testing.T) {
	ms := NewMetric()
	assert.Equal(t, "", ms.Unit())
	ms.SetUnit("1")
	assert.Equal(t, "1", ms.Unit())
}

func TestMetric_DataType(t *testing.T) {
	tv := NewMetric()
	assert.Equal(t, MetricDataTypeNone, tv.DataType())
}

func TestMetric_Gauge(t *testing.T) {
	ms := NewMetric()
	internal.FillTestGauge(internal.Gauge(ms.SetEmptyGauge()))
	assert.Equal(t, MetricDataTypeGauge, ms.DataType())
	assert.Equal(t, Gauge(internal.GenerateTestGauge()), ms.Gauge())
}

func TestMetric_CopyTo_Gauge(t *testing.T) {
	ms := NewMetric()
	internal.FillTestGauge(internal.Gauge(ms.SetEmptyGauge()))
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.Equal(t, ms, dest)
}

func TestMetric_Sum(t *testing.T) {
	ms := NewMetric()
	internal.FillTestSum(internal.Sum(ms.SetEmptySum()))
	assert.Equal(t, MetricDataTypeSum, ms.DataType())
	assert.Equal(t, Sum(internal.GenerateTestSum()), ms.Sum())
}

func TestMetric_CopyTo_Sum(t *testing.T) {
	ms := NewMetric()
	internal.FillTestSum(internal.Sum(ms.SetEmptySum()))
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.Equal(t, ms, dest)
}

func TestMetric_Histogram(t *testing.T) {
	ms := NewMetric()
	internal.FillTestHistogram(internal.Histogram(ms.SetEmptyHistogram()))
	assert.Equal(t, MetricDataTypeHistogram, ms.DataType())
	assert.Equal(t, Histogram(internal.GenerateTestHistogram()), ms.Histogram())
}

func TestMetric_CopyTo_Histogram(t *testing.T) {
	ms := NewMetric()
	internal.FillTestHistogram(internal.Histogram(ms.SetEmptyHistogram()))
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.Equal(t, ms, dest)
}

func TestMetric_ExponentialHistogram(t *testing.T) {
	ms := NewMetric()
	internal.FillTestExponentialHistogram(internal.ExponentialHistogram(ms.SetEmptyExponentialHistogram()))
	assert.Equal(t, MetricDataTypeExponentialHistogram, ms.DataType())
	assert.Equal(t, ExponentialHistogram(internal.GenerateTestExponentialHistogram()), ms.ExponentialHistogram())
}

func TestMetric_CopyTo_ExponentialHistogram(t *testing.T) {
	ms := NewMetric()
	internal.FillTestExponentialHistogram(internal.ExponentialHistogram(ms.SetEmptyExponentialHistogram()))
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.Equal(t, ms, dest)
}

func TestMetric_Summary(t *testing.T) {
	ms := NewMetric()
	internal.FillTestSummary(internal.Summary(ms.SetEmptySummary()))
	assert.Equal(t, MetricDataTypeSummary, ms.DataType())
	assert.Equal(t, Summary(internal.GenerateTestSummary()), ms.Summary())
}

func TestMetric_CopyTo_Summary(t *testing.T) {
	ms := NewMetric()
	internal.FillTestSummary(internal.Summary(ms.SetEmptySummary()))
	dest := NewMetric()
	ms.CopyTo(dest)
	assert.Equal(t, ms, dest)
}

func TestGauge_MoveTo(t *testing.T) {
	ms := Gauge(internal.GenerateTestGauge())
	dest := NewGauge()
	ms.MoveTo(dest)
	assert.Equal(t, NewGauge(), ms)
	assert.Equal(t, Gauge(internal.GenerateTestGauge()), dest)
}

func TestGauge_CopyTo(t *testing.T) {
	ms := NewGauge()
	orig := NewGauge()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Gauge(internal.GenerateTestGauge())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestGauge_DataPoints(t *testing.T) {
	ms := NewGauge()
	assert.Equal(t, NewNumberDataPointSlice(), ms.DataPoints())
	internal.FillTestNumberDataPointSlice(internal.NumberDataPointSlice(ms.DataPoints()))
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), ms.DataPoints())
}

func TestSum_MoveTo(t *testing.T) {
	ms := Sum(internal.GenerateTestSum())
	dest := NewSum()
	ms.MoveTo(dest)
	assert.Equal(t, NewSum(), ms)
	assert.Equal(t, Sum(internal.GenerateTestSum()), dest)
}

func TestSum_CopyTo(t *testing.T) {
	ms := NewSum()
	orig := NewSum()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Sum(internal.GenerateTestSum())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestSum_AggregationTemporality(t *testing.T) {
	ms := NewSum()
	assert.Equal(t, MetricAggregationTemporality(otlpmetrics.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporality(otlpmetrics.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestSum_IsMonotonic(t *testing.T) {
	ms := NewSum()
	assert.Equal(t, false, ms.IsMonotonic())
	ms.SetIsMonotonic(true)
	assert.Equal(t, true, ms.IsMonotonic())
}

func TestSum_DataPoints(t *testing.T) {
	ms := NewSum()
	assert.Equal(t, NewNumberDataPointSlice(), ms.DataPoints())
	internal.FillTestNumberDataPointSlice(internal.NumberDataPointSlice(ms.DataPoints()))
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), ms.DataPoints())
}

func TestHistogram_MoveTo(t *testing.T) {
	ms := Histogram(internal.GenerateTestHistogram())
	dest := NewHistogram()
	ms.MoveTo(dest)
	assert.Equal(t, NewHistogram(), ms)
	assert.Equal(t, Histogram(internal.GenerateTestHistogram()), dest)
}

func TestHistogram_CopyTo(t *testing.T) {
	ms := NewHistogram()
	orig := NewHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Histogram(internal.GenerateTestHistogram())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestHistogram_AggregationTemporality(t *testing.T) {
	ms := NewHistogram()
	assert.Equal(t, MetricAggregationTemporality(otlpmetrics.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporality(otlpmetrics.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestHistogram_DataPoints(t *testing.T) {
	ms := NewHistogram()
	assert.Equal(t, NewHistogramDataPointSlice(), ms.DataPoints())
	internal.FillTestHistogramDataPointSlice(internal.HistogramDataPointSlice(ms.DataPoints()))
	assert.Equal(t, HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()), ms.DataPoints())
}

func TestExponentialHistogram_MoveTo(t *testing.T) {
	ms := ExponentialHistogram(internal.GenerateTestExponentialHistogram())
	dest := NewExponentialHistogram()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogram(), ms)
	assert.Equal(t, ExponentialHistogram(internal.GenerateTestExponentialHistogram()), dest)
}

func TestExponentialHistogram_CopyTo(t *testing.T) {
	ms := NewExponentialHistogram()
	orig := NewExponentialHistogram()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = ExponentialHistogram(internal.GenerateTestExponentialHistogram())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestExponentialHistogram_AggregationTemporality(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.Equal(t, MetricAggregationTemporality(otlpmetrics.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := MetricAggregationTemporality(otlpmetrics.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func TestExponentialHistogram_DataPoints(t *testing.T) {
	ms := NewExponentialHistogram()
	assert.Equal(t, NewExponentialHistogramDataPointSlice(), ms.DataPoints())
	internal.FillTestExponentialHistogramDataPointSlice(internal.ExponentialHistogramDataPointSlice(ms.DataPoints()))
	assert.Equal(t, ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()), ms.DataPoints())
}

func TestSummary_MoveTo(t *testing.T) {
	ms := Summary(internal.GenerateTestSummary())
	dest := NewSummary()
	ms.MoveTo(dest)
	assert.Equal(t, NewSummary(), ms)
	assert.Equal(t, Summary(internal.GenerateTestSummary()), dest)
}

func TestSummary_CopyTo(t *testing.T) {
	ms := NewSummary()
	orig := NewSummary()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Summary(internal.GenerateTestSummary())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestSummary_DataPoints(t *testing.T) {
	ms := NewSummary()
	assert.Equal(t, NewSummaryDataPointSlice(), ms.DataPoints())
	internal.FillTestSummaryDataPointSlice(internal.SummaryDataPointSlice(ms.DataPoints()))
	assert.Equal(t, SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()), ms.DataPoints())
}

func TestNumberDataPointSlice(t *testing.T) {
	es := NewNumberDataPointSlice()
	assert.Equal(t, 0, es.Len())
	es = newNumberDataPointSlice(&[]*otlpmetrics.NumberDataPoint{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newNumberDataPoint(&otlpmetrics.NumberDataPoint{})
	testVal := NumberDataPoint(internal.GenerateTestNumberDataPoint())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestNumberDataPoint(internal.NumberDataPoint(el))
		assert.Equal(t, testVal, el)
	}
}

func TestNumberDataPointSlice_CopyTo(t *testing.T) {
	dest := NewNumberDataPointSlice()
	// Test CopyTo to empty
	NewNumberDataPointSlice().CopyTo(dest)
	assert.Equal(t, NewNumberDataPointSlice(), dest)

	// Test CopyTo larger slice
	NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()).CopyTo(dest)
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), dest)

	// Test CopyTo same size slice
	NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()).CopyTo(dest)
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), dest)
}

func TestNumberDataPointSlice_EnsureCapacity(t *testing.T) {
	es := NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.NumberDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.NumberDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.NumberDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestNumberDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice())
	dest := NewNumberDataPointSlice()
	src := NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestNumberDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewNumberDataPointSlice()
	emptySlice.RemoveIf(func(el NumberDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := NumberDataPointSlice(internal.GenerateTestNumberDataPointSlice())
	pos := 0
	filtered.RemoveIf(func(el NumberDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestNumberDataPoint_MoveTo(t *testing.T) {
	ms := NumberDataPoint(internal.GenerateTestNumberDataPoint())
	dest := NewNumberDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewNumberDataPoint(), ms)
	assert.Equal(t, NumberDataPoint(internal.GenerateTestNumberDataPoint()), dest)
}

func TestNumberDataPoint_CopyTo(t *testing.T) {
	ms := NewNumberDataPoint()
	orig := NewNumberDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = NumberDataPoint(internal.GenerateTestNumberDataPoint())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestNumberDataPoint_Attributes(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestNumberDataPoint_StartTimestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestNumberDataPoint_Timestamp(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestNumberDataPoint_ValueType(t *testing.T) {
	tv := NewNumberDataPoint()
	assert.Equal(t, NumberDataPointValueTypeNone, tv.ValueType())
}

func TestNumberDataPoint_DoubleVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, float64(0.0), ms.DoubleVal())
	ms.SetDoubleVal(float64(17.13))
	assert.Equal(t, float64(17.13), ms.DoubleVal())
	assert.Equal(t, NumberDataPointValueTypeDouble, ms.ValueType())
}

func TestNumberDataPoint_IntVal(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, int64(0), ms.IntVal())
	ms.SetIntVal(int64(17))
	assert.Equal(t, int64(17), ms.IntVal())
	assert.Equal(t, NumberDataPointValueTypeInt, ms.ValueType())
}

func TestNumberDataPoint_Exemplars(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	internal.FillTestExemplarSlice(internal.ExemplarSlice(ms.Exemplars()))
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), ms.Exemplars())
}

func TestNumberDataPoint_Flags(t *testing.T) {
	ms := NewNumberDataPoint()
	assert.Equal(t, MetricDataPointFlags(0), ms.Flags())
	testValFlags := MetricDataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestHistogramDataPointSlice(t *testing.T) {
	es := NewHistogramDataPointSlice()
	assert.Equal(t, 0, es.Len())
	es = newHistogramDataPointSlice(&[]*otlpmetrics.HistogramDataPoint{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newHistogramDataPoint(&otlpmetrics.HistogramDataPoint{})
	testVal := HistogramDataPoint(internal.GenerateTestHistogramDataPoint())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestHistogramDataPoint(internal.HistogramDataPoint(el))
		assert.Equal(t, testVal, el)
	}
}

func TestHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewHistogramDataPointSlice()
	// Test CopyTo to empty
	NewHistogramDataPointSlice().CopyTo(dest)
	assert.Equal(t, NewHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()).CopyTo(dest)
	assert.Equal(t, HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()), dest)

	// Test CopyTo same size slice
	HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()).CopyTo(dest)
	assert.Equal(t, HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()), dest)
}

func TestHistogramDataPointSlice_EnsureCapacity(t *testing.T) {
	es := HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.HistogramDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.HistogramDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.HistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice())
	dest := NewHistogramDataPointSlice()
	src := HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestHistogramDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewHistogramDataPointSlice()
	emptySlice.RemoveIf(func(el HistogramDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := HistogramDataPointSlice(internal.GenerateTestHistogramDataPointSlice())
	pos := 0
	filtered.RemoveIf(func(el HistogramDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestHistogramDataPoint_MoveTo(t *testing.T) {
	ms := HistogramDataPoint(internal.GenerateTestHistogramDataPoint())
	dest := NewHistogramDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewHistogramDataPoint(), ms)
	assert.Equal(t, HistogramDataPoint(internal.GenerateTestHistogramDataPoint()), dest)
}

func TestHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewHistogramDataPoint()
	orig := NewHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = HistogramDataPoint(internal.GenerateTestHistogramDataPoint())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestHistogramDataPoint_Count(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.Count())
	ms.SetCount(uint64(17))
	assert.Equal(t, uint64(17), ms.Count())
}

func TestHistogramDataPoint_Sum(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Sum())
	ms.SetSum(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Sum())
}

func TestHistogramDataPoint_BucketCounts(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, []uint64(nil), ms.BucketCounts().AsRaw())
	ms.BucketCounts().FromRaw([]uint64{1, 2, 3})
	assert.Equal(t, []uint64{1, 2, 3}, ms.BucketCounts().AsRaw())
}

func TestHistogramDataPoint_ExplicitBounds(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, []float64(nil), ms.ExplicitBounds().AsRaw())
	ms.ExplicitBounds().FromRaw([]float64{1, 2, 3})
	assert.Equal(t, []float64{1, 2, 3}, ms.ExplicitBounds().AsRaw())
}

func TestHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	internal.FillTestExemplarSlice(internal.ExemplarSlice(ms.Exemplars()))
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), ms.Exemplars())
}

func TestHistogramDataPoint_Flags(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, MetricDataPointFlags(0), ms.Flags())
	testValFlags := MetricDataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestHistogramDataPoint_Min(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Min())
	ms.SetMin(float64(9.23))
	assert.Equal(t, float64(9.23), ms.Min())
}

func TestHistogramDataPoint_Max(t *testing.T) {
	ms := NewHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Max())
	ms.SetMax(float64(182.55))
	assert.Equal(t, float64(182.55), ms.Max())
}

func TestExponentialHistogramDataPointSlice(t *testing.T) {
	es := NewExponentialHistogramDataPointSlice()
	assert.Equal(t, 0, es.Len())
	es = newExponentialHistogramDataPointSlice(&[]*otlpmetrics.ExponentialHistogramDataPoint{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newExponentialHistogramDataPoint(&otlpmetrics.ExponentialHistogramDataPoint{})
	testVal := ExponentialHistogramDataPoint(internal.GenerateTestExponentialHistogramDataPoint())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestExponentialHistogramDataPoint(internal.ExponentialHistogramDataPoint(el))
		assert.Equal(t, testVal, el)
	}
}

func TestExponentialHistogramDataPointSlice_CopyTo(t *testing.T) {
	dest := NewExponentialHistogramDataPointSlice()
	// Test CopyTo to empty
	NewExponentialHistogramDataPointSlice().CopyTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo larger slice
	ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()).CopyTo(dest)
	assert.Equal(t, ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()), dest)

	// Test CopyTo same size slice
	ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()).CopyTo(dest)
	assert.Equal(t, ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()), dest)
}

func TestExponentialHistogramDataPointSlice_EnsureCapacity(t *testing.T) {
	es := ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.ExponentialHistogramDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestExponentialHistogramDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice())
	dest := NewExponentialHistogramDataPointSlice()
	src := ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExponentialHistogramDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExponentialHistogramDataPointSlice()
	emptySlice.RemoveIf(func(el ExponentialHistogramDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := ExponentialHistogramDataPointSlice(internal.GenerateTestExponentialHistogramDataPointSlice())
	pos := 0
	filtered.RemoveIf(func(el ExponentialHistogramDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestExponentialHistogramDataPoint_MoveTo(t *testing.T) {
	ms := ExponentialHistogramDataPoint(internal.GenerateTestExponentialHistogramDataPoint())
	dest := NewExponentialHistogramDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPoint(), ms)
	assert.Equal(t, ExponentialHistogramDataPoint(internal.GenerateTestExponentialHistogramDataPoint()), dest)
}

func TestExponentialHistogramDataPoint_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	orig := NewExponentialHistogramDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = ExponentialHistogramDataPoint(internal.GenerateTestExponentialHistogramDataPoint())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestExponentialHistogramDataPoint_Attributes(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestExponentialHistogramDataPoint_StartTimestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestExponentialHistogramDataPoint_Timestamp(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestExponentialHistogramDataPoint_Count(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.Count())
	ms.SetCount(uint64(17))
	assert.Equal(t, uint64(17), ms.Count())
}

func TestExponentialHistogramDataPoint_Sum(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Sum())
	ms.SetSum(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Sum())
}

func TestExponentialHistogramDataPoint_Scale(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, int32(0), ms.Scale())
	ms.SetScale(int32(4))
	assert.Equal(t, int32(4), ms.Scale())
}

func TestExponentialHistogramDataPoint_ZeroCount(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, uint64(0), ms.ZeroCount())
	ms.SetZeroCount(uint64(201))
	assert.Equal(t, uint64(201), ms.ZeroCount())
}

func TestExponentialHistogramDataPoint_Positive(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	internal.FillTestBuckets(internal.Buckets(ms.Positive()))
	assert.Equal(t, Buckets(internal.GenerateTestBuckets()), ms.Positive())
}

func TestExponentialHistogramDataPoint_Negative(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	internal.FillTestBuckets(internal.Buckets(ms.Negative()))
	assert.Equal(t, Buckets(internal.GenerateTestBuckets()), ms.Negative())
}

func TestExponentialHistogramDataPoint_Exemplars(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, NewExemplarSlice(), ms.Exemplars())
	internal.FillTestExemplarSlice(internal.ExemplarSlice(ms.Exemplars()))
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), ms.Exemplars())
}

func TestExponentialHistogramDataPoint_Flags(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, MetricDataPointFlags(0), ms.Flags())
	testValFlags := MetricDataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestExponentialHistogramDataPoint_Min(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Min())
	ms.SetMin(float64(9.23))
	assert.Equal(t, float64(9.23), ms.Min())
}

func TestExponentialHistogramDataPoint_Max(t *testing.T) {
	ms := NewExponentialHistogramDataPoint()
	assert.Equal(t, float64(0.0), ms.Max())
	ms.SetMax(float64(182.55))
	assert.Equal(t, float64(182.55), ms.Max())
}

func TestBuckets_MoveTo(t *testing.T) {
	ms := Buckets(internal.GenerateTestBuckets())
	dest := NewBuckets()
	ms.MoveTo(dest)
	assert.Equal(t, NewBuckets(), ms)
	assert.Equal(t, Buckets(internal.GenerateTestBuckets()), dest)
}

func TestBuckets_CopyTo(t *testing.T) {
	ms := NewBuckets()
	orig := NewBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Buckets(internal.GenerateTestBuckets())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestBuckets_Offset(t *testing.T) {
	ms := NewBuckets()
	assert.Equal(t, int32(0), ms.Offset())
	ms.SetOffset(int32(909))
	assert.Equal(t, int32(909), ms.Offset())
}

func TestBuckets_BucketCounts(t *testing.T) {
	ms := NewBuckets()
	assert.Equal(t, []uint64(nil), ms.BucketCounts().AsRaw())
	ms.BucketCounts().FromRaw([]uint64{1, 2, 3})
	assert.Equal(t, []uint64{1, 2, 3}, ms.BucketCounts().AsRaw())
}

func TestSummaryDataPointSlice(t *testing.T) {
	es := NewSummaryDataPointSlice()
	assert.Equal(t, 0, es.Len())
	es = newSummaryDataPointSlice(&[]*otlpmetrics.SummaryDataPoint{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newSummaryDataPoint(&otlpmetrics.SummaryDataPoint{})
	testVal := SummaryDataPoint(internal.GenerateTestSummaryDataPoint())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestSummaryDataPoint(internal.SummaryDataPoint(el))
		assert.Equal(t, testVal, el)
	}
}

func TestSummaryDataPointSlice_CopyTo(t *testing.T) {
	dest := NewSummaryDataPointSlice()
	// Test CopyTo to empty
	NewSummaryDataPointSlice().CopyTo(dest)
	assert.Equal(t, NewSummaryDataPointSlice(), dest)

	// Test CopyTo larger slice
	SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()).CopyTo(dest)
	assert.Equal(t, SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()), dest)

	// Test CopyTo same size slice
	SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()).CopyTo(dest)
	assert.Equal(t, SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()), dest)
}

func TestSummaryDataPointSlice_EnsureCapacity(t *testing.T) {
	es := SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestSummaryDataPointSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice())
	dest := NewSummaryDataPointSlice()
	src := SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestSummaryDataPointSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewSummaryDataPointSlice()
	emptySlice.RemoveIf(func(el SummaryDataPoint) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := SummaryDataPointSlice(internal.GenerateTestSummaryDataPointSlice())
	pos := 0
	filtered.RemoveIf(func(el SummaryDataPoint) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestSummaryDataPoint_MoveTo(t *testing.T) {
	ms := SummaryDataPoint(internal.GenerateTestSummaryDataPoint())
	dest := NewSummaryDataPoint()
	ms.MoveTo(dest)
	assert.Equal(t, NewSummaryDataPoint(), ms)
	assert.Equal(t, SummaryDataPoint(internal.GenerateTestSummaryDataPoint()), dest)
}

func TestSummaryDataPoint_CopyTo(t *testing.T) {
	ms := NewSummaryDataPoint()
	orig := NewSummaryDataPoint()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = SummaryDataPoint(internal.GenerateTestSummaryDataPoint())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestSummaryDataPoint_Attributes(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestSummaryDataPoint_StartTimestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTimestamp())
	testValStartTimestamp := pcommon.Timestamp(1234567890)
	ms.SetStartTimestamp(testValStartTimestamp)
	assert.Equal(t, testValStartTimestamp, ms.StartTimestamp())
}

func TestSummaryDataPoint_Timestamp(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestSummaryDataPoint_Count(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, uint64(0), ms.Count())
	ms.SetCount(uint64(17))
	assert.Equal(t, uint64(17), ms.Count())
}

func TestSummaryDataPoint_Sum(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, float64(0.0), ms.Sum())
	ms.SetSum(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Sum())
}

func TestSummaryDataPoint_QuantileValues(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, NewValueAtQuantileSlice(), ms.QuantileValues())
	internal.FillTestValueAtQuantileSlice(internal.ValueAtQuantileSlice(ms.QuantileValues()))
	assert.Equal(t, ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()), ms.QuantileValues())
}

func TestSummaryDataPoint_Flags(t *testing.T) {
	ms := NewSummaryDataPoint()
	assert.Equal(t, MetricDataPointFlags(0), ms.Flags())
	testValFlags := MetricDataPointFlags(1)
	ms.SetFlags(testValFlags)
	assert.Equal(t, testValFlags, ms.Flags())
}

func TestValueAtQuantileSlice(t *testing.T) {
	es := NewValueAtQuantileSlice()
	assert.Equal(t, 0, es.Len())
	es = newValueAtQuantileSlice(&[]*otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newValueAtQuantile(&otlpmetrics.SummaryDataPoint_ValueAtQuantile{})
	testVal := ValueAtQuantile(internal.GenerateTestValueAtQuantile())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestValueAtQuantile(internal.ValueAtQuantile(el))
		assert.Equal(t, testVal, el)
	}
}

func TestValueAtQuantileSlice_CopyTo(t *testing.T) {
	dest := NewValueAtQuantileSlice()
	// Test CopyTo to empty
	NewValueAtQuantileSlice().CopyTo(dest)
	assert.Equal(t, NewValueAtQuantileSlice(), dest)

	// Test CopyTo larger slice
	ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()).CopyTo(dest)
	assert.Equal(t, ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()), dest)

	// Test CopyTo same size slice
	ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()).CopyTo(dest)
	assert.Equal(t, ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()), dest)
}

func TestValueAtQuantileSlice_EnsureCapacity(t *testing.T) {
	es := ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	expectedEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
	foundEs = make(map[*otlpmetrics.SummaryDataPoint_ValueAtQuantile]bool, oldLen)
	for i := 0; i < oldLen; i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)
}

func TestValueAtQuantileSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice())
	dest := NewValueAtQuantileSlice()
	src := ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestValueAtQuantileSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewValueAtQuantileSlice()
	emptySlice.RemoveIf(func(el ValueAtQuantile) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := ValueAtQuantileSlice(internal.GenerateTestValueAtQuantileSlice())
	pos := 0
	filtered.RemoveIf(func(el ValueAtQuantile) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestValueAtQuantile_MoveTo(t *testing.T) {
	ms := ValueAtQuantile(internal.GenerateTestValueAtQuantile())
	dest := NewValueAtQuantile()
	ms.MoveTo(dest)
	assert.Equal(t, NewValueAtQuantile(), ms)
	assert.Equal(t, ValueAtQuantile(internal.GenerateTestValueAtQuantile()), dest)
}

func TestValueAtQuantile_CopyTo(t *testing.T) {
	ms := NewValueAtQuantile()
	orig := NewValueAtQuantile()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = ValueAtQuantile(internal.GenerateTestValueAtQuantile())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestValueAtQuantile_Quantile(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.Equal(t, float64(0.0), ms.Quantile())
	ms.SetQuantile(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Quantile())
}

func TestValueAtQuantile_Value(t *testing.T) {
	ms := NewValueAtQuantile()
	assert.Equal(t, float64(0.0), ms.Value())
	ms.SetValue(float64(17.13))
	assert.Equal(t, float64(17.13), ms.Value())
}

func TestExemplarSlice(t *testing.T) {
	es := NewExemplarSlice()
	assert.Equal(t, 0, es.Len())
	es = newExemplarSlice(&[]otlpmetrics.Exemplar{})
	assert.Equal(t, 0, es.Len())

	es.EnsureCapacity(7)
	emptyVal := newExemplar(&otlpmetrics.Exemplar{})
	testVal := Exemplar(internal.GenerateTestExemplar())
	assert.Equal(t, 7, cap(*es.getOrig()))
	for i := 0; i < es.Len(); i++ {
		el := es.AppendEmpty()
		assert.Equal(t, emptyVal, el)
		internal.FillTestExemplar(internal.Exemplar(el))
		assert.Equal(t, testVal, el)
	}
}

func TestExemplarSlice_CopyTo(t *testing.T) {
	dest := NewExemplarSlice()
	// Test CopyTo to empty
	NewExemplarSlice().CopyTo(dest)
	assert.Equal(t, NewExemplarSlice(), dest)

	// Test CopyTo larger slice
	ExemplarSlice(internal.GenerateTestExemplarSlice()).CopyTo(dest)
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), dest)

	// Test CopyTo same size slice
	ExemplarSlice(internal.GenerateTestExemplarSlice()).CopyTo(dest)
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), dest)
}

func TestExemplarSlice_EnsureCapacity(t *testing.T) {
	es := ExemplarSlice(internal.GenerateTestExemplarSlice())
	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	expectedEs := make(map[*otlpmetrics.Exemplar]bool)
	for i := 0; i < es.Len(); i++ {
		expectedEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, es.Len(), len(expectedEs))
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	foundEs := make(map[*otlpmetrics.Exemplar]bool, es.Len())
	for i := 0; i < es.Len(); i++ {
		foundEs[es.At(i).getOrig()] = true
	}
	assert.Equal(t, expectedEs, foundEs)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	oldLen := es.Len()
	assert.Equal(t, oldLen, len(expectedEs))
	es.EnsureCapacity(ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.getOrig()))
}

func TestExemplarSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := ExemplarSlice(internal.GenerateTestExemplarSlice())
	dest := NewExemplarSlice()
	src := ExemplarSlice(internal.GenerateTestExemplarSlice())
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, ExemplarSlice(internal.GenerateTestExemplarSlice()), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	ExemplarSlice(internal.GenerateTestExemplarSlice()).MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestExemplarSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewExemplarSlice()
	emptySlice.RemoveIf(func(el Exemplar) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := ExemplarSlice(internal.GenerateTestExemplarSlice())
	pos := 0
	filtered.RemoveIf(func(el Exemplar) bool {
		pos++
		return pos%3 == 0
	})
	assert.Equal(t, 5, filtered.Len())
}

func TestExemplar_MoveTo(t *testing.T) {
	ms := Exemplar(internal.GenerateTestExemplar())
	dest := NewExemplar()
	ms.MoveTo(dest)
	assert.Equal(t, NewExemplar(), ms)
	assert.Equal(t, Exemplar(internal.GenerateTestExemplar()), dest)
}

func TestExemplar_CopyTo(t *testing.T) {
	ms := NewExemplar()
	orig := NewExemplar()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Exemplar(internal.GenerateTestExemplar())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestExemplar_Timestamp(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, pcommon.Timestamp(0), ms.Timestamp())
	testValTimestamp := pcommon.Timestamp(1234567890)
	ms.SetTimestamp(testValTimestamp)
	assert.Equal(t, testValTimestamp, ms.Timestamp())
}

func TestExemplar_ValueType(t *testing.T) {
	tv := NewExemplar()
	assert.Equal(t, ExemplarValueTypeNone, tv.ValueType())
}

func TestExemplar_DoubleVal(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, float64(0.0), ms.DoubleVal())
	ms.SetDoubleVal(float64(17.13))
	assert.Equal(t, float64(17.13), ms.DoubleVal())
	assert.Equal(t, ExemplarValueTypeDouble, ms.ValueType())
}

func TestExemplar_IntVal(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, int64(0), ms.IntVal())
	ms.SetIntVal(int64(17))
	assert.Equal(t, int64(17), ms.IntVal())
	assert.Equal(t, ExemplarValueTypeInt, ms.ValueType())
}

func TestExemplar_FilteredAttributes(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, pcommon.NewMap(), ms.FilteredAttributes())
	internal.FillTestMap(internal.Map(ms.FilteredAttributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.FilteredAttributes())
}

func TestExemplar_TraceID(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, pcommon.TraceID(data.TraceID([16]byte{})), ms.TraceID())
	testValTraceID := pcommon.TraceID(data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetTraceID(testValTraceID)
	assert.Equal(t, testValTraceID, ms.TraceID())
}

func TestExemplar_SpanID(t *testing.T) {
	ms := NewExemplar()
	assert.Equal(t, pcommon.SpanID(data.SpanID([8]byte{})), ms.SpanID())
	testValSpanID := pcommon.SpanID(data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetSpanID(testValSpanID)
	assert.Equal(t, testValSpanID, ms.SpanID())
}
