Terraform Provider
==================

- Website: https://www.terraform.io
- [![Gitter chat](https://badges.gitter.im/hashicorp-terraform/Lobby.png)](https://gitter.im/hashicorp-terraform/Lobby)
- Mailing list: [Google Groups](http://groups.google.com/group/terraform-tool)

<img src="https://cdn.rawgit.com/hashicorp/terraform-website/master/content/source/assets/images/logo-hashicorp.svg" width="600px">

Requirements
------------

-	[Terraform](https://www.terraform.io/downloads.html) 0.12 or higher
-	[Go](https://golang.org/doc/install) 1.11 (to build the provider plugin)

Developing the Provider
---------------------------

If you wish to work on the provider, you'll first need [Go](http://www.golang.org) installed on your machine (see [Requirements](#requirements) above).

To compile the provider, run `go install -mod vendor`. This will build the provider and put the provider binary in the `$GOPATH/bin` directory.

To generate or update documentation, run `go generate`.

In order to run the full suite of Acceptance tests, run `make testacc`.

*Note:* Acceptance tests create real resources, and often cost money to run.

```sh
$ make testacc
```

In order to run run a subset of the tests:

``` sh
$ TESTARGS="-run TestAccCloudscaleSubnet" make testacc
```

In order to upgrade the `cloudscale-go-sdk`.

```sh
go get -u github.com/cloudscale-ch/cloudscale-go-sdk
go mod vendor
```

To test unreleased driver versions locally add the following to your `~/.terraformrc`

```hcl
provider_installation {
  # Use go/bin as an overridden package directory
  # for the cloudscale-ch/cloudscale provider. This disables the version and checksum
  # verifications for this provider and forces Terraform to look for the
  # null provider plugin in the given directory.
  dev_overrides {
    "cloudscale-ch/cloudscale" = "/Users/alain/go/bin"
  }

  # For all other providers, install them directly from their origin provider
  # registries as normal. If you omit this, Terraform will _only_ use
  # the dev_overrides block, and so no other providers will be available.
  direct {}
}
```
