/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenInCompareAction
extends Action {
    private String name;
    private ISynchronizePageSite site;

    public OpenInCompareAction(ISynchronizePageSite site, String name) {
        this.name = name;
        this.site = site;
        Utils.initAction((IAction)this, "action.openInCompareEditor.");
    }

    public void run() {
        SyncInfo info;
        Object obj;
        ISelection selection = this.site.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof SyncInfoModelElement && (info = ((SyncInfoModelElement)obj).getSyncInfo()) != null) {
            OpenInCompareAction.openCompareEditor(this.name, info, !OpenStrategy.activateOnOpen(), this.site);
        }
    }

    public static SyncInfoCompareInput openCompareEditor(String name, SyncInfo info, boolean keepFocus, ISynchronizePageSite site) {
        Assert.isNotNull((Object)info);
        Assert.isNotNull((Object)name);
        if (info.getLocal().getType() != 1) {
            return null;
        }
        SyncInfoCompareInput input = new SyncInfoCompareInput(name, info);
        IWorkbenchPage page = null;
        if (site == null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        } else {
            page = site.getWorkbenchSite().getPage();
        }
        if (page != null) {
            IEditorPart editor = OpenInCompareAction.findReusableCompareEditor(page);
            if (editor != null) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals((Object)input)) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                    page.activate((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
            if (site != null && keepFocus) {
                site.setFocus();
            }
            return input;
        }
        return null;
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        for (int i = 0; i < editorRefs.length; ++i) {
            IEditorPart part = editorRefs[i].getEditor(true);
            if (part == null || !(part.getEditorInput() instanceof SyncInfoCompareInput) || !(part instanceof IReusableEditor) || part.isDirty()) continue;
            return part;
        }
        return null;
    }

    public static void closeCompareEditorFor(final IWorkbenchPartSite site, final IResource resource) {
        site.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorPart editor = OpenInCompareAction.findOpenCompareEditor(site, resource);
                if (editor != null) {
                    site.getPage().closeEditor(editor, true);
                }
            }
        });
    }

    public static IEditorPart findOpenCompareEditor(IWorkbenchPartSite site, IResource resource) {
        IWorkbenchPage page = site.getPage();
        IEditorReference[] editorRefs = page.getEditorReferences();
        for (int i = 0; i < editorRefs.length; ++i) {
            SyncInfo inputInfo;
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part == null) continue;
            IEditorInput input = part.getEditorInput();
            if (part == null || !(input instanceof SyncInfoCompareInput) || !(inputInfo = ((SyncInfoCompareInput)input).getSyncInfo()).getLocal().equals(resource)) continue;
            return part;
        }
        return null;
    }
}

