/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.dtd.schema;

import org.eclipse.ant.internal.ui.dtd.IAtom;
import org.eclipse.ant.internal.ui.dtd.schema.NfmNode;
import org.eclipse.ant.internal.ui.dtd.util.Factory;
import org.eclipse.ant.internal.ui.dtd.util.FactoryObject;

public class Nfm
implements FactoryObject {
    private NfmNode start;
    private NfmNode stop;
    private Nfm fNext;
    private static Factory fFactory = new Factory();

    public NfmNode getStart() {
        return this.start;
    }

    public NfmNode getStop() {
        return this.stop;
    }

    private static Nfm nfm(IAtom s) {
        Nfm nfm = Nfm.free();
        nfm.stop = NfmNode.nfmNode();
        nfm.start = NfmNode.nfmNode(s, nfm.stop);
        return nfm;
    }

    private static Nfm nfm(Nfm x) {
        Nfm nfm = Nfm.free();
        nfm.start = NfmNode.nfmNode(x.start);
        x.stop.next1 = nfm.stop = NfmNode.nfmNode();
        return nfm;
    }

    private static Nfm nfm() {
        Nfm nfm = Nfm.free();
        nfm.start = NfmNode.nfmNode();
        nfm.stop = NfmNode.nfmNode();
        return nfm;
    }

    public static Nfm getNfm(IAtom s) {
        return Nfm.nfm(s);
    }

    public static Nfm getStar(Nfm x) {
        x.stop.next2 = x.start;
        Nfm tmp = Nfm.nfm(x);
        tmp.start.next2 = tmp.stop;
        Nfm.free(x);
        return tmp;
    }

    public static Nfm getQuestion(Nfm x) {
        Nfm tmp = Nfm.nfm(x);
        tmp.start.next2 = tmp.stop;
        Nfm.free(x);
        return tmp;
    }

    public static Nfm getPlus(Nfm x) {
        x.stop.next2 = x.start;
        Nfm tmp = Nfm.nfm(x);
        Nfm.free(x);
        return tmp;
    }

    public static Nfm getOr(Nfm x, Nfm y) {
        Nfm tmp = Nfm.nfm();
        tmp.start.next1 = x.start;
        tmp.start.next2 = y.start;
        x.stop.next1 = tmp.stop;
        y.stop.next1 = tmp.stop;
        Nfm.free(x);
        Nfm.free(y);
        return tmp;
    }

    public static Nfm getComma(Nfm x, Nfm y) {
        x.stop.next1 = y.start.next1;
        x.stop.next2 = y.start.next2;
        x.stop.symbol = y.start.symbol;
        x.stop = y.stop;
        Nfm.free(y);
        return x;
    }

    public static Nfm getUnbounded(Nfm x, int min) {
        if (min == 0) {
            return Nfm.getStar(x);
        }
        if (min == 1) {
            return Nfm.getPlus(x);
        }
        Nfm last1 = Nfm.nfm(x);
        Nfm last2 = Nfm.nfm(x);
        for (int i = 2; i < min; ++i) {
            last1 = Nfm.getComma(last1, last2);
            Nfm.free(last2);
            last2 = Nfm.nfm(x);
        }
        Nfm.free(x);
        return Nfm.getComma(last1, Nfm.getStar(last2));
    }

    public static Nfm getMinMax(Nfm x, int min, int max) {
        Nfm tmp;
        int i;
        if (max == Integer.MAX_VALUE) {
            return Nfm.getUnbounded(x, min);
        }
        if (max == 0) {
            Nfm.free(x);
            return Nfm.nfm((IAtom)null);
        }
        if (max == 1) {
            if (min == 0) {
                return Nfm.getQuestion(x);
            }
            return x;
        }
        Nfm last = null;
        for (i = 0; i < min; ++i) {
            if (last == null) {
                last = Nfm.nfm(x);
                continue;
            }
            tmp = Nfm.nfm(x);
            last = Nfm.getComma(last, tmp);
            Nfm.free(tmp);
        }
        while (i < max) {
            if (last == null) {
                last = Nfm.getQuestion(x);
            } else {
                tmp = Nfm.getQuestion(x);
                last = Nfm.getComma(last, tmp);
                Nfm.free(tmp);
            }
            ++i;
        }
        Nfm.free(x);
        return last;
    }

    public FactoryObject next() {
        return this.fNext;
    }

    public void next(FactoryObject obj) {
        this.fNext = (Nfm)obj;
    }

    private static Nfm free() {
        Nfm nfm = (Nfm)fFactory.getFree();
        if (nfm == null) {
            return new Nfm();
        }
        return nfm;
    }

    public static void free(Nfm nfm) {
        nfm.stop = null;
        nfm.start = null;
        fFactory.setFree(nfm);
    }

    private Nfm() {
    }
}

