/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.KSubstWizard;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class KSubstWizardSummaryPage
extends CVSWizardPage {
    private CheckboxTableViewer tableViewer = null;
    private Command.KSubstOption[] ksubstOptions;
    private String[] ksubstOptionsDisplayText;
    private int filterType;
    private Button showUnaffectedFilesButton;
    private boolean showUnaffectedFiles;

    public KSubstWizardSummaryPage(String pageName, String title, ImageDescriptor image, boolean showUnaffectedFiles) {
        super(pageName, title, image);
        this.showUnaffectedFiles = showUnaffectedFiles;
        this.ksubstOptions = Command.KSubstOption.getAllKSubstOptions();
        this.ksubstOptionsDisplayText = new String[this.ksubstOptions.length];
        Arrays.sort(this.ksubstOptions, new Comparator(){

            public int compare(Object a, Object b) {
                String aKey = KSubstWizardSummaryPage.this.getModeDisplayText((Command.KSubstOption)a);
                String bKey = KSubstWizardSummaryPage.this.getModeDisplayText((Command.KSubstOption)b);
                return aKey.compareTo(bKey);
            }
        });
        for (int i = 0; i < this.ksubstOptions.length; ++i) {
            this.ksubstOptionsDisplayText[i] = this.getModeDisplayText(this.ksubstOptions[i]);
        }
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        this.setControl((Control)top);
        this.createWrappingLabel(top, Policy.bind("KSubstWizardSummaryPage.contents"), 0);
        WorkbenchHelp.setHelp((Control)top, (String)"org.eclipse.team.cvs.ui.keyword_substituton_summary_page_context");
        this.createSeparator(top, 0);
        this.showUnaffectedFilesButton = new Button(top, 32);
        this.showUnaffectedFilesButton.setText(Policy.bind("KSubstWizardSummaryPage.showUnaffectedFiles"));
        this.showUnaffectedFilesButton.setSelection(this.showUnaffectedFiles);
        this.showUnaffectedFilesButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BusyIndicator.showWhile((Display)KSubstWizardSummaryPage.this.getContainer().getShell().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        KSubstWizardSummaryPage.access$302(2.access$200(this.this$1), KSubstWizardSummaryPage.access$400(2.access$200(this.this$1)).getSelection());
                        KSubstWizardSummaryPage.access$500(2.access$200(this.this$1), false);
                    }
                });
            }

            static /* synthetic */ KSubstWizardSummaryPage access$200(2 x0) {
                return x0.KSubstWizardSummaryPage.this;
            }
        });
        this.tableViewer = this.createFileTableViewer(top, Policy.bind("KSubstWizardSummaryPage.summaryViewer.title"), Policy.bind("KSubstWizardSummaryPage.summaryViewer.fileHeader"), Policy.bind("KSubstWizardSummaryPage.summaryViewer.ksubstHeader"), 100);
        Dialog.applyDialogFont((Control)parent);
    }

    public CheckboxTableViewer createFileTableViewer(Composite parent, String title, String fileHeader, String ksubstHeader, int heightHint) {
        KSubstWizardSummaryPage.createLabel(parent, title);
        Table table = new Table(parent, 68384);
        GridData data = new GridData(1808);
        data.heightHint = heightHint;
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(fileHeader);
        column = new TableColumn(table, 16384);
        column.setText(ksubstHeader);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        final CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)element;
                if (columnIndex == 0) {
                    return change.getFile().getFullPath().toString();
                }
                if (columnIndex == 1) {
                    return KSubstWizardSummaryPage.this.getModeDisplayText(change.getKSubst());
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        tableViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IFile file1 = ((KSubstWizard.KSubstChangeElement)e1).getFile();
                IFile file2 = ((KSubstWizard.KSubstChangeElement)e2).getFile();
                return super.compare(viewer, (Object)file1, (Object)file2);
            }
        });
        tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)element;
                return (KSubstWizardSummaryPage.this.showUnaffectedFiles || change.isNewKSubstMode()) && change.matchesFilter(KSubstWizardSummaryPage.this.filterType);
            }
        });
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)event.getElement();
                if (tableViewer.getGrayed((Object)change)) {
                    KSubstWizardSummaryPage.this.updateCheckStatus(change);
                } else {
                    change.setExcluded(!event.getChecked());
                }
            }
        });
        TableEditor tableEditor = new TableEditor(table);
        ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)table, this.ksubstOptionsDisplayText);
        tableViewer.setCellEditors(new CellEditor[]{null, cellEditor});
        tableViewer.setColumnProperties(new String[]{"file", "mode"});
        tableViewer.setCellModifier(new ICellModifier(){

            public Object getValue(Object element, String property) {
                KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)element;
                Command.KSubstOption option = change.getKSubst();
                for (int i = 0; i < KSubstWizardSummaryPage.this.ksubstOptions.length; ++i) {
                    if (!KSubstWizardSummaryPage.this.ksubstOptions[i].equals((Object)option)) continue;
                    return new Integer(i);
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
                element = selection.getFirstElement();
                int index = (Integer)value;
                if (index != -1) {
                    KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)element;
                    Command.KSubstOption newOption = KSubstWizardSummaryPage.this.ksubstOptions[index];
                    if (!newOption.equals((Object)change.getKSubst())) {
                        change.setKSubst(newOption);
                        change.setExcluded(false);
                        tableViewer.refresh((Object)change, true);
                        KSubstWizardSummaryPage.this.updateCheckStatus(change);
                    }
                }
            }
        });
        return tableViewer;
    }

    public void setChangeList(List changes, int filterType) {
        this.filterType = filterType;
        this.tableViewer.setInput((Object)changes.toArray());
        this.refresh(true);
    }

    private void refresh(boolean updateLabels) {
        this.tableViewer.refresh(updateLabels);
        Object[] elements = (Object[])this.tableViewer.getInput();
        for (int i = 0; i < elements.length; ++i) {
            KSubstWizard.KSubstChangeElement change = (KSubstWizard.KSubstChangeElement)elements[i];
            this.updateCheckStatus(change);
        }
    }

    private void updateCheckStatus(KSubstWizard.KSubstChangeElement change) {
        if (change.isNewKSubstMode()) {
            this.tableViewer.setGrayed((Object)change, false);
            this.tableViewer.setChecked((Object)change, !change.isExcluded());
        } else {
            this.tableViewer.setGrayed((Object)change, true);
            this.tableViewer.setChecked((Object)change, false);
        }
    }

    private String getModeDisplayText(Command.KSubstOption option) {
        return option.getLongDisplayText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.showUnaffectedFilesButton.setFocus();
        }
    }

    static /* synthetic */ boolean access$302(KSubstWizardSummaryPage x0, boolean x1) {
        x0.showUnaffectedFiles = x1;
        return x0.showUnaffectedFiles;
    }

    static /* synthetic */ Button access$400(KSubstWizardSummaryPage x0) {
        return x0.showUnaffectedFilesButton;
    }

    static /* synthetic */ void access$500(KSubstWizardSummaryPage x0, boolean x1) {
        x0.refresh(x1);
    }
}

