/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.select;

import org.eclipse.jdt.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class SelectionOnMessageSend
extends MessageSend {
    private MethodBinding findNonDefaultAbstractMethod(MethodBinding methodBinding) {
        ReferenceBinding[] itsInterfaces = methodBinding.declaringClass.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = itsInterfaces;
            for (int i = 0; i <= lastPosition; ++i) {
                ReferenceBinding[] interfaces = interfacesToVisit[i];
                int length = interfaces.length;
                for (int j = 0; j < length; ++j) {
                    ReferenceBinding currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800) != 0) continue;
                    currentType.tagBits |= 0x800;
                    MethodBinding[] methods = currentType.getMethods(methodBinding.selector);
                    if (methods != null) {
                        for (int k = 0; k < methods.length; ++k) {
                            if (!methodBinding.areParametersEqual(methods[k])) continue;
                            return methods[k];
                        }
                    }
                    if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArrayArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArrayArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
            }
        }
        return methodBinding;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("<SelectOnMessageSend:");
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        output.append(this.selector).append('(');
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
            }
        }
        return output.append(")>");
    }

    public TypeBinding resolveType(BlockScope scope) {
        super.resolveType(scope);
        if (this.binding == null || !this.binding.isValidBinding() && this.binding.problemId() != 2 && this.binding.problemId() != 5 && this.binding.problemId() != 6 && this.binding.problemId() != 7) {
            throw new SelectionNodeFound();
        }
        if (this.binding.isDefaultAbstract()) {
            throw new SelectionNodeFound(this.findNonDefaultAbstractMethod(this.binding));
        }
        throw new SelectionNodeFound(this.binding);
    }
}

