/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;

class FieldArray {
    protected Buffer buffer;
    protected int offset;
    protected int length;
    protected int stride;
    protected int count;

    public FieldArray(Buffer buffer, int offset, int length, int stride, int count) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.stride = stride;
        this.count = count;
    }

    public int count() {
        return this.count;
    }

    public Field fieldAt(int i) {
        if (i >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Field(this.buffer, this.offset + i * this.stride, this.length);
    }

    public Field insert(int i) {
        ++this.count;
        if (i >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int s = this.offset + i * this.stride;
        int t = s + this.stride;
        int n = (this.count - (i + 1)) * this.stride;
        this.buffer.copyInternal(s, t, n);
        return this.fieldAt(i).clear();
    }

    public void remove(int i) {
        if (i >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int s = this.offset + (i + 1) * this.stride;
        int t = s - this.stride;
        int n = (this.count - (i + 1)) * this.stride;
        this.buffer.copyInternal(s, t, n);
        this.fieldAt(this.count - 1).clear();
        --this.count;
    }
}

