/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.Enumeration;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.UnifiedTree;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class UnifiedTreeNode
implements ILocalStoreConstants {
    protected IResource resource;
    protected UnifiedTreeNode child;
    protected UnifiedTree tree;
    protected long stat;
    protected boolean existsWorkspace;
    protected String localLocation;
    protected String localName;

    public UnifiedTreeNode(UnifiedTree tree, IResource resource, long stat, String localLocation, String localName, boolean existsWorkspace) {
        this.tree = tree;
        this.resource = resource;
        this.stat = stat;
        this.existsWorkspace = existsWorkspace;
        this.localLocation = localLocation;
        this.localName = localName;
    }

    public boolean existsInFileSystem() {
        return this.isFile() || this.isFolder();
    }

    public boolean existsInWorkspace() {
        return this.existsWorkspace;
    }

    public Enumeration getChildren() throws CoreException {
        return this.tree.getChildren(this);
    }

    protected UnifiedTreeNode getFirstChild() {
        return this.child;
    }

    public long getLastModified() {
        return CoreFileSystemLibrary.getLastModified(this.stat);
    }

    public int getLevel() {
        return this.tree.getLevel();
    }

    public String getLocalLocation() {
        return this.localLocation != null ? this.localLocation : this.tree.getLocalLocation(this.resource);
    }

    public String getLocalName() {
        return this.localName;
    }

    public IResource getResource() {
        return this.resource;
    }

    public boolean isFile() {
        return CoreFileSystemLibrary.isFile(this.stat);
    }

    public boolean isFolder() {
        return CoreFileSystemLibrary.isFolder(this.stat);
    }

    public boolean isReadOnly() {
        return CoreFileSystemLibrary.isReadOnly(this.stat);
    }

    public void setExistsWorkspace(boolean exists) {
        this.existsWorkspace = exists;
    }

    protected void setFirstChild(UnifiedTreeNode child) {
        this.child = child;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public String toString() {
        String s = this.resource == null ? "null" : this.resource.getFullPath().toString();
        return "Node: " + s;
    }

    public void removeChildrenFromTree() throws CoreException {
        this.tree.removeNodeChildrenFromQueue(this);
    }

    public void reuse(UnifiedTree tree, IResource resource, long stat, String localLocation, String localName, boolean existsWorkspace) {
        this.tree = tree;
        this.child = null;
        this.resource = resource;
        this.stat = stat;
        this.existsWorkspace = existsWorkspace;
        this.localLocation = localLocation;
        this.localName = localName;
    }
}

